/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.FerrouslimeModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.FerrouslimeEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class FerrouslimeRenderer
extends EntityRenderer<FerrouslimeEntity>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/ferrouslime.png");
    private static final ResourceLocation TEXTURE_EYES = new ResourceLocation("alexscaves:textures/entity/ferrouslime_eyes.png");
    private static final ResourceLocation TEXTURE_GEL = new ResourceLocation("alexscaves:textures/entity/ferrouslime_gel.png");
    public static final FerrouslimeModel FERROUSLIME_MODEL = new FerrouslimeModel();
    private boolean sepia = false;

    public FerrouslimeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
    }

    public void render(FerrouslimeEntity entity, float f1, float partialTicks, PoseStack poseStack, MultiBufferSource source, int light) {
        float bodyYaw = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.2f + entity.m_20206_() * 0.5f, 0.0f);
        float ageInTicks = (float)entity.f_19797_ + partialTicks;
        float orbitDist = entity.getSlimeSize(partialTicks) * 0.1f;
        for (int i = 1; i <= entity.getHeadCount(); ++i) {
            Vec3 vec3 = entity.getHeadOffsetPos(i);
            if ((float)i > entity.prevHeadCount) {
                vec3 = vec3.m_82490_((double)entity.getMergeProgress(partialTicks));
            }
            poseStack.m_85836_();
            poseStack.m_85837_(vec3.f_82479_ + (double)orbitDist * Math.sin((float)i + ageInTicks * 0.05f), vec3.f_82480_ + (double)orbitDist * Math.sin((float)(2 + i) + ageInTicks * 0.1f), vec3.f_82481_ + (double)orbitDist * Math.cos((float)i + ageInTicks * 0.035f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - bodyYaw));
            this.renderHead(entity, partialTicks, poseStack, source, light);
            poseStack.m_85849_();
        }
        float gelSize = entity.getSlimeSize(partialTicks) - 0.2f;
        poseStack.m_85836_();
        if (this.sepia || entity.isFakeEntity()) {
            this.renderGel(entity, partialTicks, poseStack, source.m_6299_(ACRenderTypes.getBookWidget(TEXTURE_GEL, this.sepia)), gelSize, light);
        } else {
            this.renderGel(entity, partialTicks, poseStack, source.m_6299_(ACRenderTypes.getGel(TEXTURE_GEL)), gelSize, light);
            this.renderGelSpikes(entity, partialTicks, poseStack, source.m_6299_(ACRenderTypes.getGelTriangles(TEXTURE_GEL)), gelSize, light);
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, f1, partialTicks, poseStack, source, light);
    }

    private void renderHead(FerrouslimeEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource source, int packedLight) {
        float bodyYaw = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        float headYaw = Mth.m_14189_((float)partialTicks, (float)entity.f_20886_, (float)entity.f_20885_) - bodyYaw;
        float headPitch = Mth.m_14189_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        FERROUSLIME_MODEL.setupAnim(entity, 0.0f, 0.0f, (float)entity.f_19797_ + partialTicks, headYaw, headPitch);
        VertexConsumer textureConsumer = source.m_6299_(this.sepia ? ACRenderTypes.getBookWidget(TEXTURE, true) : RenderType.m_110458_((ResourceLocation)TEXTURE));
        FERROUSLIME_MODEL.m_7695_(poseStack, textureConsumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer eyesConsumer = source.m_6299_(this.sepia ? ACRenderTypes.getBookWidget(TEXTURE_EYES, true) : RenderType.m_110488_((ResourceLocation)TEXTURE_EYES));
        FERROUSLIME_MODEL.m_7695_(poseStack, eyesConsumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    private void renderGelSpikes(FerrouslimeEntity entity, float partialTicks, PoseStack poseStack, VertexConsumer consumer, float size, int packedLight) {
        float length = (size + 1.0f) * entity.getAttackProgress(partialTicks);
        if (length > 0.0f) {
            for (int i = 0; i < 8; ++i) {
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252436_.m_252977_((float)(i * 45)));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(20.0f * (float)Math.sin((float)i * 2.3f + ((float)entity.f_19797_ + partialTicks) * 0.4f)));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(20.0f * (float)Math.sin((float)i * 2.3f + ((float)entity.f_19797_ + partialTicks) * 0.4f)));
                Matrix4f cubeAt = poseStack.m_85850_().m_252922_();
                Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
                this.spikeCubeFace(entity, cubeAt, matrix3f, consumer, size * 0.25f, length, size * 0.25f, packedLight);
                poseStack.m_85849_();
            }
        }
    }

    private void spikeCubeFace(FerrouslimeEntity entity, Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, float offset, float length, float width, int packedLightIn) {
        int overlayCoords = LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f);
        int hurtColor = entity.f_20916_ > 0 || entity.f_20919_ > 0 ? 10 : 255;
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, offset + length).m_6122_(255, hurtColor, hurtColor, 255).m_7421_(0.0f, 0.0f).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, width, offset).m_6122_(255, hurtColor, hurtColor, 255).m_7421_(width, length).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, 0.0f, -width, offset).m_6122_(255, hurtColor, hurtColor, 255).m_7421_(0.0f, length).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    private void renderGel(FerrouslimeEntity entity, float partialTicks, PoseStack poseStack, VertexConsumer consumer, float size, int packedLight) {
        Matrix4f cubeAt = poseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = poseStack.m_85850_().m_252943_();
        float cubeStart = size * -0.5f;
        float cubeEnd = size * 0.5f;
        float textureScale = cubeEnd - cubeStart;
        float spike = 1.0f;
        this.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeEnd, cubeStart, cubeEnd, cubeEnd, cubeEnd, cubeEnd, cubeEnd, textureScale);
        this.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeEnd, cubeEnd, cubeStart, cubeStart, cubeStart, cubeStart, cubeStart, textureScale);
        this.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeEnd, cubeEnd, cubeEnd, cubeStart, cubeStart, cubeEnd, cubeEnd, cubeStart, textureScale);
        this.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeStart, cubeStart, cubeEnd, cubeStart, cubeEnd, cubeEnd, cubeStart, textureScale);
        this.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeEnd, cubeStart, cubeStart, cubeStart, cubeStart, cubeEnd, cubeEnd, textureScale);
        this.renderCubeFace(entity, cubeAt, matrix3f, consumer, packedLight, cubeStart, cubeEnd, cubeEnd, cubeEnd, cubeEnd, cubeEnd, cubeStart, cubeStart, textureScale);
    }

    private void renderCubeFace(FerrouslimeEntity entity, Matrix4f matrix4f, Matrix3f matrix3f, VertexConsumer vertexConsumer, int packedLightIn, float f1, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float textureScale) {
        int overlayCoords = LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f);
        int hurtColor = entity.f_20916_ > 0 || entity.f_20919_ > 0 ? 10 : 255;
        vertexConsumer.m_252986_(matrix4f, f1, f3, f5).m_6122_(255, hurtColor, hurtColor, 255).m_7421_(0.0f, textureScale).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, f2, f3, f6).m_6122_(255, hurtColor, hurtColor, 255).m_7421_(textureScale, textureScale).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, f2, f4, f7).m_6122_(255, hurtColor, hurtColor, 255).m_7421_(textureScale, 0.0f).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, f1, f4, f8).m_6122_(255, hurtColor, hurtColor, 255).m_7421_(0.0f, 0.0f).m_86008_(overlayCoords).m_85969_(packedLightIn).m_252939_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(FerrouslimeEntity entity) {
        return TEXTURE;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }
}

