/*
 * Decompiled with CFR 0.152.
 */
package aquatic_creepers.item;

import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredSpawnEggItem<T extends Mob>
extends SpawnEggItem {
    public static final List<DeferredSpawnEggItem<?>> SPAWN_EGGS = new ArrayList();
    private final RegistrySupplier<? extends EntityType<T>> typeSupplier;
    private static final DispenseItemBehavior DEFAULT_DISPENSE_BEHAVIOR = (source, stack) -> {
        Direction face = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        EntityType type = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
        try {
            type.m_20592_(source.m_7727_(), stack, null, source.m_7961_().m_121945_(face), MobSpawnType.DISPENSER, face != Direction.UP, false);
        }
        catch (Exception exception) {
            DispenseItemBehavior.f_181892_.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.m_7961_(), (Object)exception);
            return ItemStack.f_41583_;
        }
        stack.m_41774_(1);
        source.m_7727_().m_220407_(GameEvent.f_157810_, source.m_7961_(), GameEvent.Context.m_223722_((BlockState)source.m_6414_()));
        return stack;
    };

    public DeferredSpawnEggItem(RegistrySupplier<EntityType<T>> entityType, int i, int j, Item.Properties properties) {
        super(null, i, j, properties);
        this.typeSupplier = entityType;
        SPAWN_EGGS.add(this);
    }

    @NotNull
    public EntityType<?> m_43228_(@Nullable CompoundTag tag) {
        EntityType type = super.m_43228_(tag);
        return type != null ? type : (EntityType)this.typeSupplier.get();
    }

    @NotNull
    public FeatureFlagSet m_245183_() {
        return ((EntityType)this.typeSupplier.get()).m_245183_();
    }

    @Nullable
    protected DispenseItemBehavior createDispenseBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    public static void registerSpawnEggsDispenserBehaviour() {
        SPAWN_EGGS.forEach(egg -> {
            DispenseItemBehavior dispenseBehavior = egg.createDispenseBehavior();
            if (dispenseBehavior != null) {
                DispenserBlock.m_52672_((ItemLike)egg, (DispenseItemBehavior)dispenseBehavior);
            }
        });
    }
}

