/*
 * Decompiled with CFR 0.152.
 */
package aquatic_creepers.forge.datagen;

import aquatic_creepers.forge.datagen.providers.AquaticCreepers_BiomeTagsGenerator;
import aquatic_creepers.forge.datagen.providers.AquaticCreepers_DatapackBuiltinProvider;
import aquatic_creepers.forge.datagen.providers.AquaticCreepers_ItemModelGenerator;
import aquatic_creepers.forge.datagen.providers.AquaticCreepers_LanguageFileGenerator;
import aquatic_creepers.forge.datagen.providers.AquaticCreepers_LootTablesBlockGenerator;
import aquatic_creepers.forge.datagen.providers.AquaticCreepers_LootTablesEntitiesGenerator;
import aquatic_creepers.forge.datagen.providers.AquaticCreepers_RecipeGenerator;
import aquatic_creepers.forge.datagen.providers.AquaticCreepers_SoundJsonGenerator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="aquatic_creepers")
public class AquaticCreepers_DataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new AquaticCreepers_ItemModelGenerator(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new AquaticCreepers_LanguageFileGenerator(output));
        generator.addProvider(event.includeClient(), (DataProvider)new AquaticCreepers_SoundJsonGenerator(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AquaticCreepers_RecipeGenerator(output));
        generator.addProvider(event.includeServer(), (DataProvider)AquaticCreepers_DataGenerator.createLootTableProviders(output));
        generator.addProvider(event.includeServer(), (DataProvider)new AquaticCreepers_DatapackBuiltinProvider(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new AquaticCreepers_BiomeTagsGenerator(output, lookupProvider, existingFileHelper));
    }

    public static LootTableProvider createLootTableProviders(PackOutput output) {
        return new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(AquaticCreepers_LootTablesBlockGenerator::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(AquaticCreepers_LootTablesEntitiesGenerator::new, LootContextParamSets.f_81415_)));
    }
}

