/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.clipboard;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import mod.chiselsandbits.api.client.clipboard.ICreativeClipboardManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.registrars.ModCreativeTabs;
import mod.chiselsandbits.utils.SimpleMaxSizedList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CreativeClipboardManager
implements ICreativeClipboardManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final CreativeClipboardManager INSTANCE = new CreativeClipboardManager();
    private final SimpleMaxSizedList<IMultiStateItemStack> cache = new SimpleMaxSizedList(IClientConfiguration.getInstance().getClipboardSize());

    public static CreativeClipboardManager getInstance() {
        return INSTANCE;
    }

    private CreativeClipboardManager() {
    }

    public void load() {
        File file = new File("chiselsandbits/clipboard.dat");
        if (!file.exists()) {
            return;
        }
        this.cache.clear();
        try {
            CompoundTag data = NbtIo.m_128937_((File)file);
            ListTag tags = data.m_128437_("clipboard", 10);
            tags.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).map(ItemStack::m_41712_).map(SingleBlockMultiStateItemStack::new).forEach(this.cache::add);
        }
        catch (IOException e) {
            LOGGER.fatal("Failed to read a clipboard file!", (Throwable)e);
        }
    }

    private void writeContentsToDisk() {
        CompoundTag data = new CompoundTag();
        ListTag tags = new ListTag();
        this.cache.stream().map(IMultiStateItemStack::toBlockStack).map(stack -> stack.m_41739_(new CompoundTag())).forEach(arg_0 -> tags.add(arg_0));
        data.m_128365_("clipboard", (Tag)tags);
        File file = new File("chiselsandbits/clipboard.dat");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
        } else {
            file.delete();
        }
        try {
            file.createNewFile();
            NbtIo.m_128944_((CompoundTag)data, (File)file);
        }
        catch (IOException e) {
            LOGGER.fatal("Failed to create a clipboard file!", (Throwable)e);
        }
    }

    private void updateCreativeTab() {
        try {
            ((CreativeModeTab)ModCreativeTabs.CLIPBOARD.get()).f_243839_ = ItemStackLinkedSet.m_261170_();
            this.cache.forEach(stack -> ((CreativeModeTab)ModCreativeTabs.CLIPBOARD.get()).f_243839_.add(stack.toBlockStack()));
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof CreativeModeInventoryScreen) {
                CreativeModeInventoryScreen screen2 = (CreativeModeInventoryScreen)screen;
                screen2.m_257687_(this.cache.stream().map(IMultiStateItemStack::toBlockStack).toList());
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to update creative tab", (Throwable)e);
        }
    }

    @Override
    public List<IMultiStateItemStack> getClipboard() {
        return ImmutableList.copyOf(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(IMultiStateItemStack multiStateItemStack) {
        SimpleMaxSizedList<IMultiStateItemStack> simpleMaxSizedList = this.cache;
        synchronized (simpleMaxSizedList) {
            if (this.cache.contains(multiStateItemStack)) {
                return;
            }
            this.cache.add(multiStateItemStack);
            this.writeContentsToDisk();
            this.updateCreativeTab();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(int index) {
        SimpleMaxSizedList<IMultiStateItemStack> simpleMaxSizedList = this.cache;
        synchronized (simpleMaxSizedList) {
            if (index < 0 || index >= this.cache.size()) {
                return;
            }
            this.cache.remove(index);
            this.writeContentsToDisk();
            this.updateCreativeTab();
        }
    }
}

