/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.tool.mode.icon;

import com.google.common.collect.Maps;
import java.util.Map;
import mod.chiselsandbits.api.client.tool.mode.icon.ISelectedToolModeIconRenderer;
import mod.chiselsandbits.api.client.tool.mode.icon.ISelectedToolModeIconRendererRegistry;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.client.tool.mode.icon.NoopSelectedToolModeIconRenderer;
import mod.chiselsandbits.client.tool.mode.icon.RootGroupTopLeftSelectedToolModeIconRenderer;
import net.minecraft.resources.ResourceLocation;

public class SelectedToolModeRendererRegistry
implements ISelectedToolModeIconRendererRegistry {
    private static final SelectedToolModeRendererRegistry INSTANCE = new SelectedToolModeRendererRegistry();
    private final Map<ResourceLocation, ISelectedToolModeIconRenderer> rendererMap = Maps.newConcurrentMap();

    public static SelectedToolModeRendererRegistry getInstance() {
        return INSTANCE;
    }

    private SelectedToolModeRendererRegistry() {
        this.register(new RootGroupTopLeftSelectedToolModeIconRenderer(), new NoopSelectedToolModeIconRenderer());
    }

    @Override
    public ISelectedToolModeIconRenderer getCurrent() {
        return this.rendererMap.getOrDefault(new ResourceLocation(IClientConfiguration.getInstance().getToolModeRenderer().get()), this.rendererMap.get(RootGroupTopLeftSelectedToolModeIconRenderer.ID));
    }

    @Override
    public ISelectedToolModeIconRendererRegistry register(ISelectedToolModeIconRenderer ... renderers) {
        for (ISelectedToolModeIconRenderer renderer : renderers) {
            if (this.rendererMap.put(renderer.getId(), renderer) == null) continue;
            throw new IllegalArgumentException("The renderer id: " + String.valueOf(renderer.getId()) + " is already in use!");
        }
        return this;
    }
}

