/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.trigger;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.stevekung.fishofthieves.FishOfThieves;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WaterDripOnBlockTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = FishOfThieves.id("water_drip_on_block");

    public ResourceLocation m_7295_() {
        return ID;
    }

    public TriggerInstance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext deserializationContext) {
        Block block = WaterDripOnBlockTrigger.deserializeBlock(json);
        StatePropertiesPredicate statePropertiesPredicate = StatePropertiesPredicate.m_67679_((JsonElement)json.get("state"));
        LocationPredicate locationPredicate = LocationPredicate.m_52629_((JsonElement)json.get("location"));
        if (block != null) {
            statePropertiesPredicate.m_67672_(block.m_49965_(), string -> {
                throw new JsonSyntaxException("Block " + String.valueOf(block) + " has no property " + string);
            });
        }
        return new TriggerInstance(predicate, block, statePropertiesPredicate, locationPredicate);
    }

    @Nullable
    private static Block deserializeBlock(JsonObject json) {
        if (json.has("block")) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"block"));
            return (Block)BuiltInRegistries.f_256975_.m_6612_(resourceLocation).orElseThrow(() -> new JsonSyntaxException("Unknown block type '" + String.valueOf(resourceLocation) + "'"));
        }
        return null;
    }

    public void trigger(ServerLevel serverLevel, BlockPos blockPos, ServerPlayer player, BlockState state) {
        this.m_66234_(player, triggerInstance -> triggerInstance.matches(state, serverLevel, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        @Nullable
        private final Block block;
        private final StatePropertiesPredicate state;
        private final LocationPredicate location;

        public TriggerInstance(ContextAwarePredicate player, @Nullable Block block, StatePropertiesPredicate state, LocationPredicate location) {
            super(ID, player);
            this.block = block;
            this.state = state;
            this.location = location;
        }

        public static TriggerInstance waterDrip(Block block, StatePropertiesPredicate.Builder statePredicate) {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, block, statePredicate.m_67706_(), LocationPredicate.f_52592_);
        }

        public static TriggerInstance waterDrip(Block block, StatePropertiesPredicate.Builder statePredicate, LocationPredicate.Builder locationPredicate) {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, block, statePredicate.m_67706_(), locationPredicate.m_52658_());
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject jsonObject = super.m_7683_(context);
            if (this.block != null) {
                jsonObject.addProperty("block", BuiltInRegistries.f_256975_.m_7981_((Object)this.block).toString());
            }
            jsonObject.add("location", this.location.m_52616_());
            jsonObject.add("state", this.state.m_67666_());
            return jsonObject;
        }

        public boolean matches(BlockState state, ServerLevel serverLevel, double x, double y, double z) {
            return (this.block == null || state.m_60713_(this.block)) && this.state.m_67667_(state) && this.location.m_52617_(serverLevel, x, y, z);
        }
    }
}

