/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.storage;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class BaitPreserveSavedData
extends SavedData {
    public static final String FILE_ID = "fishofthieves_bait_preserve";
    private static final String TAG_BAIT_PRESERVES = "bait_preserves";
    private final Map<Vec3, ItemStack> baitStorage;

    private BaitPreserveSavedData(Map<Vec3, ItemStack> baitStorage) {
        this.baitStorage = baitStorage;
    }

    public BaitPreserveSavedData() {
        this(new ConcurrentHashMap<Vec3, ItemStack>());
    }

    public static BaitPreserveSavedData load(CompoundTag tag) {
        ConcurrentHashMap<Vec3, ItemStack> baitStorage = new ConcurrentHashMap<Vec3, ItemStack>();
        ListTag listTag = tag.m_128437_(TAG_BAIT_PRESERVES, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            baitStorage.put(new Vec3(compoundTag.m_128459_("x"), compoundTag.m_128459_("y"), compoundTag.m_128459_("z")), ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("item")));
        }
        return new BaitPreserveSavedData(baitStorage);
    }

    public void spawnBaitOnLoad(Level level) {
        Iterator<Map.Entry<Vec3, ItemStack>> iterator = this.baitStorage.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Vec3, ItemStack> entry = iterator.next();
            BlockPos blockPos = BlockPos.m_274446_((Position)((Position)entry.getKey()));
            if (!level.m_46749_(blockPos)) continue;
            Vec3 vec3 = Vec3.m_272021_((Vec3i)blockPos, (double)0.5, (double)0.25, (double)0.5).m_272010_(level.f_46441_, 0.3f);
            ItemEntity itemEntity = new ItemEntity(level, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), entry.getValue());
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
            iterator.remove();
            this.m_77762_();
        }
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        if (!this.baitStorage.isEmpty()) {
            ListTag listTag = new ListTag();
            for (Map.Entry<Vec3, ItemStack> entry : this.baitStorage.entrySet()) {
                CompoundTag baitStorageTag = new CompoundTag();
                Vec3 pos = entry.getKey();
                baitStorageTag.m_128365_("item", (Tag)entry.getValue().m_41739_(new CompoundTag()));
                baitStorageTag.m_128347_("x", pos.f_82479_);
                baitStorageTag.m_128347_("y", pos.f_82480_);
                baitStorageTag.m_128347_("z", pos.f_82481_);
                listTag.add((Object)baitStorageTag);
            }
            compoundTag.m_128365_(TAG_BAIT_PRESERVES, (Tag)listTag);
        }
        return compoundTag;
    }

    public Map<Vec3, ItemStack> getBaitStorage() {
        return this.baitStorage;
    }
}

