/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.shoal;

import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.shoal.ShoalChance;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public final class ShoalSpawner {
    private ShoalSpawner() {
    }

    @Nullable
    public static BlockPos spawn(ServerLevel level, int x, int z) {
        return ShoalSpawner.spawnShoalAtSuitablePos(level, level.m_46496_(x, level.m_5736_(), z, 0));
    }

    public static Optional<BlockPos> findFarthest(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int minimumDistance, int maximumDistance, PoiManager poiManager) {
        return ShoalSpawner.getInRange(typePredicate, pos, minimumDistance, maximumDistance, poiManager).map(PoiRecord::m_27257_).min(Comparator.comparingDouble(blockPos2 -> blockPos2.m_123331_((Vec3i)pos)));
    }

    private static Stream<PoiRecord> getInRange(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int minimumDistance, int maximumDistance, PoiManager poiManager) {
        int minSum = minimumDistance * minimumDistance;
        int maxSum = maximumDistance * maximumDistance;
        return ShoalSpawner.getInSquare(typePredicate, pos, minimumDistance, maximumDistance, poiManager).filter(poiRecord -> {
            BlockPos blockPos = poiRecord.m_27257_();
            FishOfThieves.LOGGER.debug("minSum {} <= {}: {}", new Object[]{blockPos.m_123331_((Vec3i)pos), minSum, blockPos.m_123331_((Vec3i)pos) >= (double)minSum});
            FishOfThieves.LOGGER.debug("maxSum {} <= {}: {}", new Object[]{blockPos.m_123331_((Vec3i)pos), maxSum, blockPos.m_123331_((Vec3i)pos) <= (double)maxSum});
            return blockPos.m_123331_((Vec3i)pos) >= (double)minSum && blockPos.m_123331_((Vec3i)pos) <= (double)maxSum;
        });
    }

    private static Stream<PoiRecord> getInSquare(Predicate<Holder<PoiType>> typePredicate, BlockPos pos, int minimumDistance, int maximumDistance, PoiManager poiManager) {
        int chunkRadius = Math.floorDiv(maximumDistance, 16) + 1;
        return ChunkPos.m_45596_((ChunkPos)new ChunkPos(pos), (int)chunkRadius).flatMap(chunkPos -> poiManager.m_27117_(typePredicate, chunkPos, PoiManager.Occupancy.ANY)).filter(poiRecord -> {
            BlockPos blockPos2 = poiRecord.m_27257_();
            FishOfThieves.LOGGER.debug("absX: {}", (Object)Math.abs(blockPos2.m_123341_() - pos.m_123341_()));
            FishOfThieves.LOGGER.debug("absZ: {}", (Object)Math.abs(blockPos2.m_123343_() - pos.m_123343_()));
            FishOfThieves.LOGGER.debug("minimumDistance: {}", (Object)minimumDistance);
            FishOfThieves.LOGGER.debug("maximumDistance: {}", (Object)maximumDistance);
            FishOfThieves.LOGGER.debug("logic minimumDistance: {}", (Object)(Math.abs(blockPos2.m_123341_() - pos.m_123341_()) >= minimumDistance && Math.abs(blockPos2.m_123343_() - pos.m_123343_()) >= minimumDistance ? 1 : 0));
            FishOfThieves.LOGGER.debug("logic maximumDistance: {}", (Object)(Math.abs(blockPos2.m_123341_() - pos.m_123341_()) <= maximumDistance && Math.abs(blockPos2.m_123343_() - pos.m_123343_()) <= maximumDistance ? 1 : 0));
            return Math.abs(blockPos2.m_123341_() - pos.m_123341_()) >= minimumDistance && Math.abs(blockPos2.m_123343_() - pos.m_123343_()) >= minimumDistance && Math.abs(blockPos2.m_123341_() - pos.m_123341_()) <= maximumDistance && Math.abs(blockPos2.m_123343_() - pos.m_123343_()) <= maximumDistance;
        });
    }

    public static BlockPos attemptSpawnShoal(ServerLevel serverLevel, BlockPos blockPos, int maxAttempt) {
        if (maxAttempt > 0) {
            ChunkPos chunkPos;
            BlockPos shoalPos = null;
            ChunkPos currentChunkPos = new ChunkPos(blockPos);
            Iterator iterator = ChunkPos.m_45596_((ChunkPos)currentChunkPos, (int)8).toList().iterator();
            while (iterator.hasNext() && (shoalPos = ShoalSpawner.spawn(serverLevel, (chunkPos = (ChunkPos)iterator.next()).m_45604_(), chunkPos.m_45605_())) == null) {
            }
            if (shoalPos == null) {
                FishOfThieves.LOGGER.debug("Shoal spawning attempt: {}", (Object)maxAttempt);
                return ShoalSpawner.attemptSpawnShoal(serverLevel, blockPos, maxAttempt - 1);
            }
            FishOfThieves.LOGGER.debug("Attempted to spawn shoal at: {}", (Object)shoalPos.m_7495_());
            return shoalPos.m_7495_();
        }
        return null;
    }

    @Nullable
    private static BlockPos spawnShoalAtSuitablePos(ServerLevel level, BlockPos pos) {
        BlockPos blockPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, pos);
        Holder biome = level.m_204166_(blockPos);
        boolean isException = biome.m_203656_(FOTTags.Biomes.SHOAL_CANNOT_SPAWN);
        if (isException || !biome.m_203656_(FOTTags.Biomes.SPAWNS_SHOAL) || ShoalSpawner.findNearestExistingShoal(level, blockPos).isPresent()) {
            return null;
        }
        BlockState belowState = level.m_8055_(blockPos.m_7495_());
        if (belowState.m_60713_(Blocks.f_50126_)) {
            blockPos = blockPos.m_7495_();
        }
        if ((ShoalSpawner.isOpenWater(level, blockPos) || belowState.m_60713_(Blocks.f_50126_)) && ShoalChance.canSpawnAt(level, blockPos)) {
            level.m_7731_(blockPos.m_7495_(), FOTBlocks.SHOAL.m_49966_(), 3);
            Shoal shoal = (Shoal)FOTEntities.SHOAL.m_20615_((Level)level);
            shoal.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() - 0.75, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
            shoal.createNaturalSpawn(true);
            level.m_7967_((Entity)shoal);
            FishOfThieves.LOGGER.debug("Spawn shoal at region {}, {}, {}, {}", new Object[]{((ResourceKey)biome.m_203543_().get()).m_135782_(), blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()});
            if (FishOfThieves.CONFIG.debug.spawnBeaconAtShoal && FOTPlatform.isDevelopment()) {
                ShoalSpawner.spawnBeacon(level, blockPos);
            }
            return blockPos;
        }
        return null;
    }

    private static Optional<BlockPos> findNearestExistingShoal(ServerLevel level, BlockPos pos) {
        Optional optional = level.m_8904_().m_148658_(holder -> holder.m_203656_(FOTTags.PoiTypes.SHOAL), blockPos -> level.m_8055_(blockPos.m_6630_(1)).m_60713_(Blocks.f_50126_) || blockPos.m_123342_() == level.m_6924_(Heightmap.Types.WORLD_SURFACE, blockPos.m_123341_(), blockPos.m_123343_()) - 1, pos, FishOfThieves.CONFIG.shoal.spreadDistance, PoiManager.Occupancy.ANY);
        return optional.map(blockPos -> blockPos.m_6630_(1));
    }

    private static boolean isOpenWater(ServerLevel level, BlockPos pos) {
        boolean hasSourceWater = BlockPos.m_121990_((BlockPos)pos.m_7918_(-2, -1, -2), (BlockPos)pos.m_7918_(2, -2, 2)).allMatch(blockPos -> {
            BlockState blockState = level.m_8055_(blockPos);
            FluidState fluidState = blockState.m_60819_();
            return fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_() && blockState.m_60812_((BlockGetter)level, blockPos).m_83281_();
        });
        boolean hasOpenAir = BlockPos.m_121990_((BlockPos)pos.m_7918_(-2, 0, -2), (BlockPos)pos.m_7918_(2, 0, 2)).allMatch(blockPos -> {
            BlockState blockState = level.m_8055_(blockPos);
            return level.m_45527_(blockPos) && blockState.m_60795_() && !blockState.m_60713_(Blocks.f_50196_);
        });
        return hasSourceWater && hasOpenAir;
    }

    private static void spawnBeacon(ServerLevel level, BlockPos blockPos) {
        for (BlockPos blockPos1 : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-1, -5, -1), (BlockPos)blockPos.m_7918_(1, -5, 1))) {
            level.m_7731_(blockPos1, Blocks.f_50075_.m_49966_(), 3);
        }
        level.m_7731_(blockPos.m_6625_(4), Blocks.f_50273_.m_49966_(), 3);
    }
}

