/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.shoal;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.shoal.ShoalSpawnContext;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public enum ShoalChance {
    RIVER_OR_BEACH(context -> context.biome().m_203656_(BiomeTags.f_207605_) || context.biome().m_203656_(BiomeTags.f_207604_), FishOfThieves.CONFIG.shoal.weight.riverOrBeach),
    TROPICAL_ISLAND(context -> context.biome().m_203565_(FOTBiomes.TROPICAL_ISLAND), FishOfThieves.CONFIG.shoal.weight.tropicalIsland),
    COAST(context -> context.continentalness() == Continentalness.COAST, FishOfThieves.CONFIG.shoal.weight.coast),
    OCEAN(context -> context.biome().m_203656_(BiomeTags.f_207603_), FishOfThieves.CONFIG.shoal.weight.ocean),
    DEEP_OCEAN(context -> context.biome().m_203656_(BiomeTags.f_207602_), FishOfThieves.CONFIG.shoal.weight.deepOcean),
    SWAMP(context -> context.biome().m_203565_(Biomes.f_48207_) || context.biome().m_203565_(Biomes.f_220595_), FishOfThieves.CONFIG.shoal.weight.swamp);

    private static final ShoalChance[] VALUES;
    private final Predicate<ShoalSpawnContext> context;
    private final int poolWeight;

    private ShoalChance(Predicate<ShoalSpawnContext> context, int poolWeight) {
        this.context = context;
        this.poolWeight = poolWeight;
    }

    private boolean canSpawnAt(ServerLevel level, BlockPos blockPos, RandomSource randomSource) {
        Continentalness continentalness;
        Holder biome = level.m_204166_(blockPos);
        ShoalSpawnContext context = new ShoalSpawnContext((Holder<Biome>)biome, continentalness = TerrainUtils.getContinentalness(level, blockPos));
        if (this.context.test(context)) {
            float weight = (float)this.poolWeight / 100.0f;
            float randomChance = randomSource.m_188501_();
            boolean canSpawn = weight <= randomChance;
            FishOfThieves.LOGGER.debug("Shoal {} at {}, weight/randomChance: {} <= {}, canSpawn: {}", new Object[]{this.name(), blockPos.m_123344_(), Float.valueOf(weight), Float.valueOf(randomChance), canSpawn});
            return canSpawn;
        }
        return false;
    }

    public static boolean canSpawnAt(ServerLevel level, BlockPos blockPos) {
        return ((ShoalChance)((Object)Util.m_214670_((Object[])VALUES, (RandomSource)level.m_213780_()))).canSpawnAt(level, blockPos, level.m_213780_());
    }

    static {
        VALUES = ShoalChance.values();
    }
}

