/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class WreckerVariants {
    public static final WreckerVariant ROSE = WreckerVariant.builder().condition(SpawnSelectors.always()).texture("rose").build();
    public static final WreckerVariant SUN = WreckerVariant.builder().condition(SpawnSelectors.simpleSpawn(SpawnSelectors.dayAndSeeSky())).texture("sun").glowTexture("sun_glow").build();
    public static final WreckerVariant BLACKCLOUD = WreckerVariant.builder().condition(SpawnSelectors.thunderingAndSeeSky()).texture("blackcloud").glowTexture("blackcloud_glow").build();
    public static final WreckerVariant SNOW = WreckerVariant.builder().condition(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.variant.snowWreckerProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.variant.snowWreckerProbability).and(SpawnSelectors.biomeTag(FOTTags.Biomes.SPAWNS_SNOW_WRECKERS)))).texture("snow").glowTexture("snow_glow").build();
    public static final WreckerVariant MOON = WreckerVariant.builder().condition(SpawnSelectors.simpleSpawn(true, SpawnSelectors.nightAndSeeSky().and(context -> context.level().m_46940_() > 0.0f))).texture("moon").glowTexture("moon_glow").build();
    public static final WreckerVariant EMERALD = WreckerVariant.builder().condition(SpawnSelectors.never()).texture("treasured/emerald").glowTexture("treasured/emerald_glow").treasured().build();

    public static void init() {
        WreckerVariants.register("rose", ROSE);
        WreckerVariants.register("sun", SUN);
        WreckerVariants.register("blackcloud", BLACKCLOUD);
        WreckerVariants.register("snow", SNOW);
        WreckerVariants.register("moon", MOON);
        WreckerVariants.register("emerald", EMERALD);
    }

    private static void register(String key, WreckerVariant variant) {
        Registry.m_122965_(FOTRegistry.WRECKER_VARIANT, (ResourceLocation)FishOfThieves.id(key), (Object)variant);
    }
}

