/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.WildsplashVariant;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class WildsplashVariants {
    public static final WildsplashVariant RUSSET = WildsplashVariant.builder().condition(SpawnSelectors.always()).texture("russet").build();
    public static final WildsplashVariant SANDY = WildsplashVariant.builder().condition(SpawnSelectors.simpleSpawn(SpawnSelectors.biomeTag(FOTTags.Biomes.SPAWNS_SANDY_WILDSPLASH).and(SpawnSelectors.continentalness(Continentalness.COAST))).or(context -> context.biomeTag().m_203565_(FOTBiomes.TROPICAL_ISLAND))).texture("sandy").build();
    public static final WildsplashVariant OCEAN = WildsplashVariant.builder().condition(SpawnSelectors.simpleSpawn(SpawnSelectors.biomeTag(FOTTags.Biomes.SPAWNS_OCEAN_WILDSPLASH))).texture("ocean").build();
    public static final WildsplashVariant MUDDY = WildsplashVariant.builder().condition(SpawnSelectors.simpleSpawn(FishOfThieves.CONFIG.spawnRate.variant.muddyWildsplashProbability, SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.variant.muddyWildsplashProbability).and(SpawnSelectors.biomeTag(FOTTags.Biomes.SPAWNS_MUDDY_WILDSPLASH)))).texture("muddy").build();
    public static final WildsplashVariant CORAL = WildsplashVariant.builder().condition(SpawnSelectors.simpleSpawn(true, SpawnSelectors.biomeTag(FOTTags.Biomes.SPAWNS_CORAL_WILDSPLASH).and(SpawnConditionContext::isNight).and(context -> TerrainUtils.lookForBlocksWithSize(context.blockPos(), 3, 16, blockPos -> context.level().m_8055_(blockPos).m_204336_(FOTTags.Blocks.CORAL_WILDSPLASH_SPAWNABLE_ON))))).texture("coral").glowTexture("coral_glow").build();
    public static final WildsplashVariant CALICO = WildsplashVariant.builder().condition(SpawnSelectors.never()).texture("treasured/calico").glowTexture("treasured/calico_glow").treasured().build();

    public static void init() {
        WildsplashVariants.register("russet", RUSSET);
        WildsplashVariants.register("sandy", SANDY);
        WildsplashVariants.register("ocean", OCEAN);
        WildsplashVariants.register("muddy", MUDDY);
        WildsplashVariants.register("coral", CORAL);
        WildsplashVariants.register("calico", CALICO);
    }

    private static void register(String key, WildsplashVariant variant) {
        Registry.m_122965_(FOTRegistry.WILDSPLASH_VARIANT, (ResourceLocation)FishOfThieves.id(key), (Object)variant);
    }
}

