/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.PlentifinVariant;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class PlentifinVariants {
    public static final PlentifinVariant OLIVE = PlentifinVariant.builder().condition(SpawnSelectors.always()).texture("olive").build();
    public static final PlentifinVariant AMBER = PlentifinVariant.builder().condition(SpawnSelectors.simpleSpawn(SpawnSelectors.rainingAndSeeSky().negate().and(context -> {
        float time = context.level().m_46942_(1.0f);
        return time >= 0.75f && time <= 0.9f;
    }).and(SpawnConditionContext::seeSkyInWater))).texture("amber").build();
    public static final PlentifinVariant CLOUDY = PlentifinVariant.builder().condition(SpawnSelectors.simpleSpawn(SpawnSelectors.rainingAndSeeSky())).texture("cloudy").build();
    public static final PlentifinVariant BONEDUST = PlentifinVariant.builder().condition(SpawnSelectors.probability(FishOfThieves.CONFIG.spawnRate.variant.bonedustPlentifinProbability)).texture("bonedust").build();
    public static final PlentifinVariant WATERY = PlentifinVariant.builder().condition(SpawnSelectors.nightAndSeeSky()).texture("watery").glowTexture("watery_glow").build();
    public static final PlentifinVariant CRIMSON = PlentifinVariant.builder().condition(SpawnSelectors.never()).texture("treasured/crimson").glowTexture("treasured/crimson_glow").treasured().build();

    public static void init() {
        PlentifinVariants.register("olive", OLIVE);
        PlentifinVariants.register("amber", AMBER);
        PlentifinVariants.register("cloudy", CLOUDY);
        PlentifinVariants.register("bonedust", BONEDUST);
        PlentifinVariants.register("watery", WATERY);
        PlentifinVariants.register("crimson", CRIMSON);
    }

    private static void register(String key, PlentifinVariant variant) {
        Registry.m_122965_(FOTRegistry.PLENTIFIN_VARIANT, (ResourceLocation)FishOfThieves.id(key), (Object)variant);
    }
}

