/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.level;

import com.llamalad7.mixinextras.sugar.Local;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.shoal.ShoalSpawner;
import com.stevekung.fishofthieves.storage.BaitPreserveSavedData;
import com.stevekung.fishofthieves.storage.BaitStorageAccessor;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerLevel
extends Level
implements BaitStorageAccessor {
    @Unique
    private BaitPreserveSavedData bait;

    MixinServerLevel() {
        super(null, null, null, null, null, false, false, 0L, 0);
    }

    @Inject(method={"tickChunk"}, at={@At(value="INVOKE", target="net/minecraft/server/level/ServerLevel.isThundering()Z")})
    private void fishofthieves$specialThunderTick(LevelChunk chunk, int randomTickSpeed, CallbackInfo info, @Local(index=5, ordinal=1) int x, @Local(index=6, ordinal=2) int z) {
        Optional<BlockPos> blockPos;
        if (this.m_46470_() && this.f_46441_.m_188503_(5000) == 0 && (blockPos = this.findNearestStormfish(this.m_46496_(x, 0, z, 15))).isPresent()) {
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)this);
            lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)((Vec3i)blockPos.get())));
            this.m_7967_((Entity)lightningBolt);
        }
    }

    @Inject(method={"tickChunk"}, at={@At(value="CONSTANT", args={"stringValue=thunder"})})
    private void fishofthieves$shoalTick(LevelChunk chunk, int randomTickSpeed, CallbackInfo info, @Local(index=5, ordinal=1) int x, @Local(index=6, ordinal=2) int z, @Local ProfilerFiller profilerFiller) {
        if (this.m_46469_().m_46207_(FishOfThieves.SHOAL_SPAWNING)) {
            int chance;
            profilerFiller.m_6180_("fishofthieves_shoal");
            int n = chance = this.m_46471_() ? FishOfThieves.CONFIG.shoal.chanceRaining : FishOfThieves.CONFIG.shoal.chance;
            if (this.f_46441_.m_188503_(chance) == 0) {
                ShoalSpawner.spawn((ServerLevel)ServerLevel.class.cast(this), x, z);
            }
            profilerFiller.m_7238_();
        }
    }

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    private void fishofthieves$initBaitPreserve(CallbackInfo info) {
        this.bait = (BaitPreserveSavedData)((ServerLevel)ServerLevel.class.cast(this)).m_8895_().m_164861_(BaitPreserveSavedData::load, BaitPreserveSavedData::new, "fishofthieves_bait_preserve");
    }

    @Override
    public BaitPreserveSavedData getBaitPreserve() {
        return this.bait;
    }

    @Unique
    private boolean isRainingAtFromBelowWater(BlockPos blockPos) {
        if (!this.m_46471_() || !this.m_46861_(blockPos) || this.m_45517_(LightLayer.SKY, blockPos) < 12) {
            return false;
        }
        Biome biome = (Biome)this.m_204166_(blockPos).m_203334_();
        return biome.m_264600_(blockPos) == Biome.Precipitation.RAIN;
    }

    @Unique
    private Optional<BlockPos> findNearestStormfish(BlockPos blockPos) {
        BlockPos blockPos2 = this.m_5452_(Heightmap.Types.MOTION_BLOCKING, blockPos);
        AABB aabb = new AABB(blockPos2, new BlockPos(blockPos2.m_123341_(), this.m_151558_(), blockPos2.m_123343_())).m_82400_(8.0);
        return Optional.of(this.m_142425_((EntityTypeTest)FOTEntities.STORMFISH, aabb, living -> living != null && living.m_6084_() && this.isRainingAtFromBelowWater(blockPos2))).filter(stormfish -> !stormfish.isEmpty()).map(stormfish -> ((Stormfish)stormfish.get(this.f_46441_.m_188503_(stormfish.size()))).m_20183_());
    }
}

