/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.entity;

import com.llamalad7.mixinextras.sugar.Local;
import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.entity.FishingHookBait;
import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.storage.BaitPreserveSavedData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public abstract class MixinFishingHook
extends Projectile
implements FishingHookBait {
    @Shadow
    int f_37090_;
    @Unique
    private ItemStack baitStack = ItemStack.f_41583_;
    @Unique
    private boolean isCreative;
    @Unique
    private boolean saved;

    @Shadow
    abstract Player m_37168_();

    MixinFishingHook() {
        super(null, null);
    }

    public boolean m_20223_(CompoundTag compound) {
        Level level;
        if (!this.isCreative && !this.saved && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BaitPreserveSavedData baitPreserveSavedData = serverLevel.getBaitPreserve();
            baitPreserveSavedData.getBaitStorage().putIfAbsent(this.m_20182_(), this.baitStack);
            baitPreserveSavedData.m_77762_();
            this.saved = true;
        }
        return super.m_20223_(compound);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="net/minecraft/world/entity/projectile/FishingHook.discard()V")})
    private void fishofthieves$dropBaitOnDiscardTick(CallbackInfo info) {
        this.dropBait();
    }

    @Inject(method={"shouldStopFishing"}, at={@At(value="INVOKE", target="net/minecraft/world/entity/projectile/FishingHook.discard()V")})
    private void fishofthieves$dropBaitOnDiscardRemoved(Player player, CallbackInfoReturnable<Boolean> info) {
        this.dropBait();
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void fishofthieves$sendPacketOnFirstTick(CallbackInfo info) {
        if (this.m_9236_() instanceof ServerLevel && this.f_19797_ == 1) {
            FOTPlatform.sendFishingHookBait((FishingHook)FishingHook.class.cast(this));
        }
    }

    @Inject(method={"retrieve"}, at={@At(value="INVOKE", target="net/minecraft/advancements/critereon/FishingRodHookedTrigger.trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/projectile/FishingHook;Ljava/util/Collection;)V", shift=At.Shift.AFTER, ordinal=1)})
    private void fishofthieves$onRetrieve(ItemStack stack, CallbackInfoReturnable<Integer> info) {
        this.shrinkBait(false);
    }

    @Inject(method={"catchingFish"}, at={@At(value="INVOKE", target="net/minecraft/network/syncher/SynchedEntityData.set(Lnet/minecraft/network/syncher/EntityDataAccessor;Ljava/lang/Object;)V", ordinal=0)})
    private void fishofthieves$shrinkBait(BlockPos pos, CallbackInfo info) {
        this.shrinkBait(true);
    }

    @Inject(method={"catchingFish"}, at={@At(value="FIELD", target="net/minecraft/world/entity/projectile/FishingHook.timeUntilLured:I", opcode=181, ordinal=1, shift=At.Shift.AFTER)}, slice={@Slice(from=@At(value="INVOKE", target="net/minecraft/util/Mth.nextInt(Lnet/minecraft/util/RandomSource;II)I", ordinal=1))})
    private void fishofthieves$increaseLureByBait(BlockPos pos, CallbackInfo info) {
        if (this.baitStack.m_204117_(FOTTags.Items.WORMS)) {
            this.f_37090_ = Mth.m_14107_((double)((double)this.f_37090_ * 0.9));
        }
    }

    @Inject(method={"retrieve"}, cancellable=true, at={@At(value="INVOKE", target="net/minecraft/advancements/critereon/FishingRodHookedTrigger.trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/projectile/FishingHook;Ljava/util/Collection;)V", shift=At.Shift.AFTER, ordinal=1)})
    private void fishofthieves$fishUpShoal(ItemStack itemStack, CallbackInfoReturnable<Integer> info, @Local Player player) {
        Shoal shoal;
        boolean intersects;
        List shoals = this.m_9236_().m_6443_(Shoal.class, this.m_20191_().m_82400_(1.0), Entity::m_6084_);
        if (!shoals.isEmpty() && (intersects = (shoal = (Shoal)((Object)shoals.get(0))).m_20191_().m_82381_(this.m_20191_().m_82400_(1.0)))) {
            LivingEntity randomFish = shoal.getRandomFishInShoal();
            if (randomFish == null) {
                return;
            }
            shoal.addParticipatePlayer(player.m_20148_());
            double dx = player.m_20185_() - this.m_20185_();
            double dy = player.m_20186_() - this.m_20186_();
            double dz = player.m_20189_() - this.m_20189_();
            double power = 0.15;
            double gravity = 0.12;
            randomFish.m_20035_(this.m_20183_(), -player.m_146908_(), -player.m_146909_());
            randomFish.m_20334_(dx * power, dy * power + Math.sqrt(Math.sqrt(dx * dx + dy * dy + dz * dz)) * gravity, dz * power);
            randomFish.m_20301_(500);
            this.m_9236_().m_7967_((Entity)randomFish);
            player.m_9236_().m_7967_((Entity)new ExperienceOrb(player.m_9236_(), player.m_20185_() + 0.5, player.m_20186_() + 0.5, player.m_20189_() + 0.5, this.f_19796_.m_188503_(8) + 2));
            this.m_146870_();
            info.setReturnValue((Object)4);
        }
    }

    @Override
    public void fishofthieves$setBaitStack(ItemStack itemStack) {
        this.baitStack = itemStack;
    }

    @Override
    public ItemStack fishofthieves$getBaitStack() {
        return this.baitStack;
    }

    @Override
    public void fishofthieves$setIsCreative() {
        this.isCreative = true;
    }

    @Unique
    private void shrinkBait(boolean sendPacket) {
        Player player = this.m_37168_();
        if (player != null && !this.baitStack.m_41619_() && !player.m_150110_().f_35937_) {
            this.baitStack.m_41774_(1);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this.baitStack.m_41720_()));
            if (sendPacket) {
                FOTPlatform.sendFishingHookBait((FishingHook)FishingHook.class.cast(this));
            }
        }
    }

    @Unique
    private void dropBait() {
        Level level;
        if (!this.isCreative && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 vec3 = Vec3.m_272021_((Vec3i)this.m_20183_(), (double)0.5, (double)0.25, (double)0.5).m_272010_(this.f_19796_, 0.3f);
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), this.baitStack);
            itemEntity.m_32060_();
            this.m_9236_().m_7967_((Entity)itemEntity);
            BaitPreserveSavedData baitPreserveSavedData = serverLevel.getBaitPreserve();
            baitPreserveSavedData.getBaitStorage().remove(this.m_20182_());
            baitPreserveSavedData.m_77762_();
        }
    }
}

