/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.stevekung.fishofthieves.loot.predicate.StructureRangeCondition;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;

public record FOTLocationPredicate(TagKey<Biome> biome, StructureRangeCondition structureRangeCondition, Continentalness continentalness, Boolean hasRaids) {
    public static final FOTLocationPredicate ANY = new FOTLocationPredicate(null, null, null, null);

    public boolean matches(ServerLevel level, @Nullable Entity entity, double x, double y, double z) {
        BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        boolean loaded = level.m_46749_(blockPos);
        boolean isRaided = level.m_8843_(blockPos);
        return (this.biome == null || loaded && level.m_204166_(blockPos).m_203656_(this.biome)) && (this.structureRangeCondition == null || loaded && this.isInRangeOfStructures(level, blockPos, entity, this.structureRangeCondition, (Registry<Structure>)level.m_9598_().m_175515_(Registries.f_256944_))) && (this.continentalness == null || loaded && this.continentalness == TerrainUtils.getContinentalness(level, blockPos)) && (this.hasRaids == null || loaded && this.hasRaids == isRaided);
    }

    private boolean isInRangeOfStructures(ServerLevel level, BlockPos blockPos, @Nullable Entity entity, StructureRangeCondition structureRangeCondition, Registry<Structure> structureRegistry) {
        Optional structureHolderSet = structureRegistry.m_203431_(structureRangeCondition.structure());
        int structureRange = structureRangeCondition.range().m_146499_();
        if (structureHolderSet.isPresent()) {
            for (Holder structureHolder : (HolderSet.Named)structureHolderSet.get()) {
                Structure structure = (Structure)structureHolder.m_203334_();
                boolean isInsideStructure = level.m_215010_().m_220524_(blockPos, structure).m_73603_();
                if (entity == null) {
                    return isInsideStructure;
                }
                if (isInsideStructure) {
                    return true;
                }
                int distFromStructure = Integer.MAX_VALUE;
                BlockPos entityPos = entity.m_20183_();
                ChunkPos entityChunkPos = level.m_46865_(entityPos).m_7697_();
                Structure structure1 = null;
                ChunkPos chunkPos1 = null;
                for (ChunkPos chunkPos : ChunkPos.m_45596_((ChunkPos)entityChunkPos, (int)structureRangeCondition.chunkRadius().m_146499_()).toList()) {
                    Map structureRefMap = level.m_46819_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62315_).m_62769_();
                    Optional<Structure> optional = structureRefMap.keySet().stream().filter(structurex -> structurex.equals(structure)).findAny();
                    if (!optional.isPresent()) continue;
                    structure1 = optional.get();
                    chunkPos1 = chunkPos;
                }
                if (structure1 == null) continue;
                for (StructureStart structureStart : level.m_215010_().m_220504_(SectionPos.m_123196_(chunkPos1, (int)0), structure1)) {
                    Integer structureDist = structureStart.m_73602_().stream().map(structurePiece -> structurePiece.m_73547_().m_162394_().m_123333_((Vec3i)entityPos)).findAny().orElse(Integer.MAX_VALUE);
                    if (structureDist < distFromStructure) {
                        distFromStructure = structureDist;
                    }
                    if (distFromStructure <= structureRange) continue;
                    break;
                }
                if (distFromStructure >= structureRange) continue;
                return true;
            }
        }
        return false;
    }

    public JsonElement serializeToJson() {
        if (this == ANY) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (this.biome != null) {
            jsonObject.addProperty("biome", this.biome.f_203868_().toString());
        }
        if (this.structureRangeCondition != null) {
            JsonObject jsonStructureObject = new JsonObject();
            jsonStructureObject.addProperty("structure", this.structureRangeCondition.structure().f_203868_().toString());
            jsonStructureObject.addProperty("range", (Number)this.structureRangeCondition.range().m_146499_());
            jsonStructureObject.addProperty("chunk_radius", (Number)this.structureRangeCondition.chunkRadius().m_146499_());
            jsonObject.add("structure", (JsonElement)jsonStructureObject);
        }
        if (this.continentalness != null) {
            jsonObject.addProperty("continentalness", this.continentalness.m_7912_());
        }
        if (this.hasRaids != null) {
            jsonObject.addProperty("hasRaids", this.hasRaids);
        }
        return jsonObject;
    }

    public static FOTLocationPredicate fromJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"location");
        TagKey biome = null;
        StructureRangeCondition structureRangeCondition = null;
        Continentalness continentalness = null;
        Boolean hasRaids = null;
        if (jsonObject.has("biome")) {
            String string = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"biome");
            biome = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(string));
        }
        if (jsonObject.has("structure")) {
            JsonObject jsonStructureObject = GsonHelper.m_13841_((JsonObject)jsonObject, (String)"structure", (JsonObject)new JsonObject());
            String structure = GsonHelper.m_13906_((JsonObject)jsonStructureObject, (String)"structure");
            ConstantInt range = ConstantInt.m_146483_((int)GsonHelper.m_13927_((JsonObject)jsonStructureObject, (String)"range"));
            ConstantInt chunkRadius = ConstantInt.m_146483_((int)GsonHelper.m_13927_((JsonObject)jsonStructureObject, (String)"chunk_radius"));
            structureRangeCondition = new StructureRangeCondition((TagKey<Structure>)TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation(structure)), range, chunkRadius);
        }
        if (jsonObject.has("continentalness")) {
            continentalness = Continentalness.byName(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"continentalness"));
        }
        if (jsonObject.has("hasRaids")) {
            hasRaids = GsonHelper.m_13912_((JsonObject)jsonObject, (String)"hasRaids");
        }
        return new FOTLocationPredicate((TagKey<Biome>)biome, structureRangeCondition, continentalness, hasRaids);
    }

    public static class Builder {
        @Nullable
        private TagKey<Biome> biome;
        @Nullable
        private StructureRangeCondition structureRangeCondition;
        @Nullable
        private Continentalness continentalness;
        @Nullable
        private Boolean hasRaids;

        public static Builder location() {
            return new Builder();
        }

        public Builder setBiome(@Nullable TagKey<Biome> biome) {
            this.biome = biome;
            return this;
        }

        public Builder setStructureInRange(TagKey<Structure> structure, int range, int chunkRadius) {
            this.structureRangeCondition = new StructureRangeCondition(structure, ConstantInt.m_146483_((int)range), ConstantInt.m_146483_((int)chunkRadius));
            return this;
        }

        public Builder setContinentalness(@Nullable Continentalness continentalness) {
            this.continentalness = continentalness;
            return this;
        }

        public Builder hasRaids() {
            this.hasRaids = true;
            return this;
        }

        public FOTLocationPredicate build() {
            return new FOTLocationPredicate(this.biome, this.structureRangeCondition, this.continentalness, this.hasRaids);
        }
    }
}

