/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.function;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.registry.FOTLootItemFunctions;
import com.stevekung.fishofthieves.registry.FOTMapDecorationTypes;
import com.stevekung.fishofthieves.registry.FOTPoiTypes;
import com.stevekung.fishofthieves.shoal.ShoalSpawner;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class TreasuredFishMapFunction
extends LootItemConditionalFunction {
    private final byte zoom;
    private final int minimumSearchRadius;
    private final int maximumSearchRadius;
    private final int maxAttempt;
    private final float highTierChance;

    TreasuredFishMapFunction(LootItemCondition[] conditions, byte zoom, int minimumSearchRadius, int maximumSearchRadius, int maxAttempt, float highTierChance) {
        super(conditions);
        this.zoom = zoom;
        this.minimumSearchRadius = minimumSearchRadius;
        this.maximumSearchRadius = maximumSearchRadius;
        this.maxAttempt = maxAttempt;
        this.highTierChance = highTierChance;
    }

    public LootItemFunctionType m_7162_() {
        return FOTLootItemFunctions.TREASURED_FISH_MAP;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81460_);
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        if (stack.m_150930_(Items.f_42676_)) {
            Vec3 vec3 = (Vec3)context.m_78953_(LootContextParams.f_81460_);
            if (vec3 == null) {
                return stack;
            }
            ServerLevel serverLevel = context.m_78952_();
            Optional<BlockPos> farthest = ShoalSpawner.findFarthest(holder -> holder.m_203565_(FOTPoiTypes.NATURAL_SHOAL), BlockPos.m_274446_((Position)vec3), this.minimumSearchRadius, this.maximumSearchRadius, serverLevel.m_8904_());
            if (farthest.isPresent()) {
                BlockPos blockPos = farthest.get();
                FishOfThieves.LOGGER.debug("Found farthest shoal at: {}", (Object)blockPos);
                return TreasuredFishMapFunction.createTreasuredFishMap(serverLevel, blockPos, context, this.zoom, this.highTierChance);
            }
            BlockPos attemptPos = ShoalSpawner.attemptSpawnShoal(serverLevel, BlockPos.m_274446_((Position)vec3), this.maxAttempt);
            if (attemptPos != null) {
                FishOfThieves.LOGGER.debug("Shoal spawn from map at: {}", (Object)attemptPos);
                return TreasuredFishMapFunction.createTreasuredFishMap(serverLevel, attemptPos, context, this.zoom, this.highTierChance);
            }
            Optional nearest = serverLevel.m_8904_().m_27192_(holder -> holder.m_203565_(FOTPoiTypes.NATURAL_SHOAL), BlockPos.m_274446_((Position)vec3), this.maximumSearchRadius, PoiManager.Occupancy.ANY);
            if (nearest.isPresent()) {
                BlockPos blockPos = (BlockPos)nearest.get();
                FishOfThieves.LOGGER.debug("Found nearest shoal at: {}", (Object)blockPos);
                return TreasuredFishMapFunction.createTreasuredFishMap(serverLevel, blockPos, context, this.zoom, this.highTierChance);
            }
        }
        return stack;
    }

    private static ItemStack createTreasuredFishMap(ServerLevel serverLevel, BlockPos blockPos, LootContext context, byte zoom, float highTierChance) {
        ItemStack itemStack = MapItem.m_42886_((Level)serverLevel, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)zoom, (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)serverLevel, (ItemStack)itemStack);
        MapItemSavedData.m_77925_((ItemStack)itemStack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)FOTMapDecorationTypes.TREASURED_FISH);
        Shoal.setTreasuredShoal((Level)serverLevel, blockPos, context.m_230907_().m_188501_() < highTierChance ? 1 : 2);
        return itemStack;
    }

    public static Builder makeTreasuredFishMap() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private byte zoom = (byte)2;
        private int minimumSearchRadius;
        private int maximumSearchRadius;
        private int maxAttempt;
        private float highTierChance;

        protected Builder getThis() {
            return this;
        }

        public Builder setZoom(byte zoom) {
            this.zoom = zoom;
            return this;
        }

        public Builder setMinimumSearchRadius(int minimumSearchRadius) {
            this.minimumSearchRadius = minimumSearchRadius;
            return this;
        }

        public Builder setMaximumSearchRadius(int maximumSearchRadius) {
            this.maximumSearchRadius = maximumSearchRadius;
            return this;
        }

        public Builder setMaxAttempt(int maxAttempt) {
            this.maxAttempt = maxAttempt;
            return this;
        }

        public Builder setHighTierChance(float highTierChance) {
            this.highTierChance = highTierChance;
            return this;
        }

        public LootItemFunction m_7453_() {
            return new TreasuredFishMapFunction(this.m_80699_(), this.zoom, this.minimumSearchRadius, this.maximumSearchRadius, this.maxAttempt, this.highTierChance);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<TreasuredFishMapFunction> {
        public void serialize(JsonObject json, TreasuredFishMapFunction treasuredFishMapFunction, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)treasuredFishMapFunction, serializationContext);
            if (treasuredFishMapFunction.zoom != 2) {
                json.addProperty("zoom", (Number)treasuredFishMapFunction.zoom);
            }
            json.addProperty("mininum_search_radius", (Number)treasuredFishMapFunction.minimumSearchRadius);
            json.addProperty("maximum_search_radius", (Number)treasuredFishMapFunction.maximumSearchRadius);
            json.addProperty("max_attempt", (Number)treasuredFishMapFunction.maxAttempt);
            json.addProperty("high_tier_chance", (Number)Float.valueOf(treasuredFishMapFunction.highTierChance));
        }

        public TreasuredFishMapFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
            byte zoom = GsonHelper.m_13816_((JsonObject)object, (String)"zoom", (byte)2);
            int minimumSearchRadius = GsonHelper.m_13927_((JsonObject)object, (String)"mininum_search_radius");
            int maximumSearchRadius = GsonHelper.m_13927_((JsonObject)object, (String)"maximum_search_radius");
            int maxAttempt = GsonHelper.m_13927_((JsonObject)object, (String)"max_attempt");
            float highTierChance = GsonHelper.m_13915_((JsonObject)object, (String)"high_tier_chance");
            return new TreasuredFishMapFunction(conditions, zoom, minimumSearchRadius, maximumSearchRadius, maxAttempt, highTierChance);
        }
    }
}

