/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.function;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.stevekung.fishofthieves.registry.FOTLootItemFunctions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetRandomFireworkFunction
extends LootItemConditionalFunction {
    private static final FireworkRocketItem.Shape[] VALUES = FireworkRocketItem.Shape.values();
    private final List<Integer> fireworkColors;

    SetRandomFireworkFunction(LootItemCondition[] lootItemConditions, List<Integer> fireworkColors) {
        super(lootItemConditions);
        this.fireworkColors = ImmutableList.copyOf(fireworkColors);
    }

    public LootItemFunctionType m_7162_() {
        return FOTLootItemFunctions.SET_RANDOM_FIREWORK;
    }

    public ItemStack m_7372_(ItemStack itemStack, LootContext context) {
        if (itemStack.m_150930_(Items.f_42688_) && !this.fireworkColors.isEmpty()) {
            RandomSource random = context.m_230907_();
            CompoundTag compoundTag = itemStack.m_41698_("Fireworks");
            ListTag listTag = new ListTag();
            CompoundTag explosionTag = new CompoundTag();
            boolean flicker = random.m_188499_();
            boolean trail = random.m_188499_();
            if (flicker) {
                explosionTag.m_128379_("Flicker", true);
            }
            if (trail) {
                explosionTag.m_128379_("Trail", true);
            }
            explosionTag.m_128408_("Colors", List.of((Integer)Util.m_214621_(this.fireworkColors, (RandomSource)random)));
            explosionTag.m_128408_("FadeColors", List.of(Integer.valueOf(DyeColor.WHITE.m_41070_())));
            explosionTag.m_128344_("Type", (byte)((FireworkRocketItem.Shape)Util.m_214670_((Object[])VALUES, (RandomSource)random)).m_41236_());
            listTag.add((Object)explosionTag);
            compoundTag.m_128344_("Flight", (byte)(1 + random.m_188503_(3)));
            compoundTag.m_128365_("Explosions", (Tag)listTag);
        }
        return itemStack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final List<Integer> fireworkColors = new ArrayList<Integer>();

        protected Builder getThis() {
            return this;
        }

        public Builder withColor(DyeColor color) {
            this.fireworkColors.add(color.m_41070_());
            return this;
        }

        public Builder withColor(int color) {
            this.fireworkColors.add(color);
            return this;
        }

        public LootItemFunction m_7453_() {
            return new SetRandomFireworkFunction(this.m_80699_(), this.fireworkColors);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<SetRandomFireworkFunction> {
        public void serialize(JsonObject json, SetRandomFireworkFunction value, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)value, serializationContext);
            if (!value.fireworkColors.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (Integer fireworkColor : value.fireworkColors) {
                    jsonArray.add(serializationContext.serialize((Object)fireworkColor));
                }
                json.add("colors", (JsonElement)jsonArray);
            }
        }

        public SetRandomFireworkFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
            ArrayList<Integer> fireworkColors = new ArrayList<Integer>();
            if (object.has("colors")) {
                for (JsonElement jsonElement : GsonHelper.m_13933_((JsonObject)object, (String)"colors")) {
                    fireworkColors.add(jsonElement.getAsInt());
                }
            }
            return new SetRandomFireworkFunction(conditions, fireworkColors);
        }
    }
}

