/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.stevekung.fishofthieves.item.FOTItem;
import com.stevekung.fishofthieves.registry.FOTLootPoolEntries;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class FOTTagEntry
extends LootPoolSingletonContainer {
    final TagKey<Item> tag;
    final boolean expand;

    FOTTagEntry(TagKey<Item> tagKey, boolean expand, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.tag = tagKey;
        this.expand = expand;
    }

    public LootPoolEntryType m_6751_() {
        return FOTLootPoolEntries.TAG;
    }

    public void m_6948_(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        BuiltInRegistries.f_257033_.m_206058_(this.tag).forEach(holder -> this.createItemStackWithData(stackConsumer, lootContext, (Holder<Item>)holder));
    }

    private void createItemStackWithData(Consumer<ItemStack> stackConsumer, LootContext lootContext, Holder<Item> holder) {
        ItemStack itemStack = new ItemStack(holder);
        Vec3 vec3 = (Vec3)lootContext.m_78953_(LootContextParams.f_81460_);
        stackConsumer.accept(FOTItem.generateRandomFishVariantLootItem(itemStack, lootContext.m_78952_(), vec3, lootContext.m_230907_()));
    }

    private boolean expandTag(LootContext context, Consumer<LootPoolEntry> generatorConsumer) {
        if (!this.m_79639_(context)) {
            return false;
        }
        for (final Holder holder : BuiltInRegistries.f_257033_.m_206058_(this.tag)) {
            generatorConsumer.accept((LootPoolEntry)new LootPoolSingletonContainer.EntryBase(){

                public void m_6941_(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
                    FOTTagEntry.this.createItemStackWithData(stackConsumer, lootContext, (Holder<Item>)holder);
                }
            });
        }
        return true;
    }

    public boolean m_6562_(LootContext lootContext, Consumer<LootPoolEntry> consumer) {
        return this.expand ? this.expandTag(lootContext, consumer) : super.m_6562_(lootContext, consumer);
    }

    public static LootPoolSingletonContainer.Builder<?> expandTag(TagKey<Item> tag) {
        return FOTTagEntry.m_79687_((weight, quality, conditions, functions) -> new FOTTagEntry(tag, true, weight, quality, conditions, functions));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<FOTTagEntry> {
        public void serializeCustom(JsonObject object, FOTTagEntry context, JsonSerializationContext conditions) {
            super.m_7219_(object, (LootPoolSingletonContainer)context, conditions);
            object.addProperty("name", context.tag.f_203868_().toString());
            object.addProperty("expand", Boolean.valueOf(context.expand));
        }

        protected FOTTagEntry deserialize(JsonObject object, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"name"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourceLocation);
            boolean expand = GsonHelper.m_13912_((JsonObject)object, (String)"expand");
            return new FOTTagEntry((TagKey<Item>)tagKey, expand, weight, quality, conditions, functions);
        }
    }
}

