/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.stevekung.fishofthieves.item.FOTItem;
import com.stevekung.fishofthieves.registry.FOTLootPoolEntries;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;

public class FOTLootItem
extends LootPoolSingletonContainer {
    final Item item;

    FOTLootItem(Item item, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
        super(weight, quality, conditions, functions);
        this.item = item;
    }

    public LootPoolEntryType m_6751_() {
        return FOTLootPoolEntries.ITEM;
    }

    public void m_6948_(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        ItemStack itemStack = new ItemStack((ItemLike)this.item);
        Vec3 vec3 = (Vec3)lootContext.m_78953_(LootContextParams.f_81460_);
        stackConsumer.accept(FOTItem.generateRandomFishVariantLootItem(itemStack, lootContext.m_78952_(), vec3, lootContext.m_230907_()));
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableItem(ItemLike item) {
        return FOTLootItem.m_79687_((weight, quality, conditions, functions) -> new FOTLootItem(item.m_5456_(), weight, quality, conditions, functions));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<FOTLootItem> {
        public void serializeCustom(JsonObject object, FOTLootItem context, JsonSerializationContext conditions) {
            super.m_7219_(object, (LootPoolSingletonContainer)context, conditions);
            ResourceLocation resourceLocation = BuiltInRegistries.f_257033_.m_7981_((Object)context.item);
            if (resourceLocation == null) {
                throw new IllegalArgumentException("Can't serialize unknown item " + String.valueOf(context.item));
            }
            object.addProperty("name", resourceLocation.toString());
        }

        protected FOTLootItem deserialize(JsonObject object, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            Item item = GsonHelper.m_13909_((JsonObject)object, (String)"name");
            return new FOTLootItem(item, weight, quality, conditions, functions);
        }
    }
}

