/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.stevekung.fishofthieves.registry.FOTLootItemConditions;
import java.util.Set;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record BaitAttachedCondition(ItemPredicate itemPredicate, EntityPredicate entityPredicate) implements LootItemCondition
{
    public LootItemConditionType m_7940_() {
        return FOTLootItemConditions.BAIT_ATTACHED_HOOK;
    }

    public Set<LootContextParam<?>> m_6231_() {
        return Set.of(LootContextParams.f_81455_);
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        return entity != null && this.entityPredicate.m_36607_(context.m_78952_(), null, entity) && this.checkBaitFromHook(entity);
    }

    private boolean checkBaitFromHook(Entity entity) {
        if (entity instanceof FishingHook) {
            FishingHook fishingHook = (FishingHook)entity;
            ItemStack baitStack = fishingHook.fishofthieves$getBaitStack();
            return !baitStack.m_41619_() && this.itemPredicate.m_45049_(baitStack);
        }
        return false;
    }

    public static LootItemCondition.Builder baitMatches(ItemPredicate.Builder itemPredicateBuilder, EntityPredicate.Builder entityPredicateBuilder) {
        return () -> new BaitAttachedCondition(itemPredicateBuilder.m_45077_(), entityPredicateBuilder.m_36662_());
    }

    public static class Serializer
    implements net.minecraft.world.level.storage.loot.Serializer<BaitAttachedCondition> {
        public void serialize(JsonObject jsonObject, BaitAttachedCondition baitAttachedCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.add("item_predicate", baitAttachedCondition.itemPredicate.m_45048_());
            jsonObject.add("entity_predicate", baitAttachedCondition.entityPredicate.m_36606_());
        }

        public BaitAttachedCondition deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            ItemPredicate itemPredicate = ItemPredicate.m_45051_((JsonElement)jsonObject.get("item_predicate"));
            EntityPredicate entityPredicate = EntityPredicate.m_36614_((JsonElement)jsonObject.get("entity_predicate"));
            return new BaitAttachedCondition(itemPredicate, entityPredicate);
        }
    }
}

