/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot;

import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.loot.condition.BaitAttachedCondition;
import com.stevekung.fishofthieves.loot.function.FOTLootItem;
import com.stevekung.fishofthieves.loot.function.FOTTagEntry;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTLootItemConditions;
import com.stevekung.fishofthieves.registry.FOTLootTables;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class FOTLootManager {
    public static void dropWorms(List<ItemStack> droppedList, BlockState blockState, LootDataManager lootDataManager, LootParams lootParams) {
        if (FishOfThieves.CONFIG.general.enableEarthwormsDrop && blockState.m_204336_(FOTTags.Blocks.EARTHWORMS_DROPS) && !blockState.m_204336_(FOTTags.Blocks.EARTHWORMS_DROP_BLACKLIST)) {
            droppedList.addAll((Collection<ItemStack>)lootDataManager.m_278676_(FOTLootTables.Blocks.EARTHWORMS_DROPS).m_287195_(lootParams));
        }
        if (FishOfThieves.CONFIG.general.enableGrubsDrop && blockState.m_204336_(FOTTags.Blocks.GRUBS_DROPS)) {
            droppedList.addAll((Collection<ItemStack>)lootDataManager.m_278676_(FOTLootTables.Blocks.GRUBS_DROPS).m_287195_(lootParams));
        }
        if (FishOfThieves.CONFIG.general.enableLeechesDrop && blockState.m_204336_(FOTTags.Blocks.LEECHES_DROPS)) {
            droppedList.addAll((Collection<ItemStack>)lootDataManager.m_278676_(FOTLootTables.Blocks.LEECHES_DROPS).m_287195_(lootParams));
        }
    }

    public static Map<ResourceLocation, Function<LootPool.Builder, LootPool.Builder>> getInjectedLootTableMap() {
        return (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(BuiltInLootTables.f_78730_, FOTLootManager::getFishermanGiftLoot);
            map.put(BuiltInLootTables.f_78720_, builder -> FOTLootManager.getFishingLoot(builder, true));
            map.put(BuiltInLootTables.f_78723_, builder -> FOTLootManager.getFishingLoot(builder, false));
            map.put(BuiltInLootTables.f_78721_, builder -> builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTBlocks.FISH_BONE).m_79707_(1)));
            map.put(EntityType.f_20514_.m_20677_(), FOTLootManager::getPolarBearLoot);
            map.put(EntityType.f_20559_.m_20677_(), FOTLootManager::getDolphinLoot);
            map.put(BuiltInLootTables.f_276611_, FOTLootManager::getOceanRuinsArchaeologyLoot);
            map.put(BuiltInLootTables.f_276614_, FOTLootManager::getOceanRuinsArchaeologyLoot);
        });
    }

    public static Map<ResourceLocation, Function<LootPool.Builder, LootPool.Builder>> getInjectedLootPoolMap() {
        return (Map)Util.m_137469_(new HashMap(), map -> {
            map.put(EntityType.f_20455_.m_20677_(), builder -> FOTLootManager.getGuardianLoot(builder, false));
            map.put(EntityType.f_20563_.m_20677_(), builder -> FOTLootManager.getGuardianLoot(builder, true));
            map.put(BuiltInLootTables.f_78751_, FOTLootManager::getVillageFisherLoot);
            map.put(BuiltInLootTables.f_78692_, FOTLootManager::getBuriedTreasureLoot);
            map.put(BuiltInLootTables.f_78694_, FOTLootManager::getShipwreckSupplyLoot);
            map.put(BuiltInLootTables.f_78686_, FOTLootManager::getJungleTempleLoot);
        });
    }

    public static LootPool.Builder getFishermanGiftLoot(LootPool.Builder builder) {
        return builder.m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL)).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.PONDIE)).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.ISLEHOPPER)).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.ANCIENTSCALE)).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.PLENTIFIN)).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.WILDSPLASH)).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.DEVILFISH)).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.BATTLEGILL)).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.WRECKER)).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.STORMFISH).m_79080_(FOTLootItemConditions.THUNDERING));
    }

    public static LootPool.Builder getFishingLoot(LootPool.Builder builder, boolean useBaits) {
        ArrayList<Pair> fishLoot = new ArrayList<Pair>();
        fishLoot.add(Pair.of(null, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL).m_79707_(50).m_79080_(FOTLootItemConditions.IN_OCEAN))));
        fishLoot.add(Pair.of(null, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.PONDIE).m_79707_(50).m_79080_((LootItemCondition.Builder)FOTLootItemConditions.IN_RIVER.m_285888_(FOTLootItemConditions.IN_FOREST)))));
        fishLoot.add(Pair.of(null, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.ISLEHOPPER).m_79707_(40).m_79080_(FOTLootItemConditions.COAST))));
        fishLoot.add(Pair.of(FOTTags.Items.LEECHES_FOOD, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.ANCIENTSCALE).m_79707_(40).m_79080_((LootItemCondition.Builder)FOTLootItemConditions.IN_LUKEWARM_OCEAN.m_285888_(FOTLootItemConditions.IN_DEEP_LUKEWARM_OCEAN)))));
        fishLoot.add(Pair.of(FOTTags.Items.EARTHWORMS_FOOD, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.PLENTIFIN).m_79707_(45).m_79080_((LootItemCondition.Builder)FOTLootItemConditions.IN_LUKEWARM_OCEAN.m_285888_(FOTLootItemConditions.IN_DEEP_LUKEWARM_OCEAN).m_285888_(FOTLootItemConditions.IN_WARM_OCEAN)))));
        fishLoot.add(Pair.of(FOTTags.Items.EARTHWORMS_FOOD, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.WILDSPLASH).m_79707_(45).m_79080_((LootItemCondition.Builder)FOTLootItemConditions.IN_LUSH_CAVES.m_285888_(FOTLootItemConditions.IN_JUNGLE)))));
        fishLoot.add(Pair.of(FOTTags.Items.GRUBS_FOOD, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.DEVILFISH).m_79707_(35).m_79080_(FOTLootItemConditions.IN_DRIPSTONE_CAVES))));
        fishLoot.add(Pair.of(FOTTags.Items.GRUBS_FOOD, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.BATTLEGILL).m_79707_(35).m_79080_((LootItemCondition.Builder)FOTLootItemConditions.IN_OCEAN_MONUMENTS.m_285888_(FOTLootItemConditions.IN_PILLAGER_OUTPOSTS).m_285888_(FOTLootItemConditions.HAS_RAIDS)))));
        fishLoot.add(Pair.of(FOTTags.Items.EARTHWORMS_FOOD, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.WRECKER).m_79707_(20).m_79080_(FOTLootItemConditions.IN_SHIPWRECKS_OR_RUINED_PORTAL_OCEAN))));
        fishLoot.add(Pair.of(FOTTags.Items.LEECHES_FOOD, (Object)((LootPoolSingletonContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.STORMFISH).m_79707_(20).m_79080_(FOTLootItemConditions.THUNDERING))));
        if (useBaits) {
            fishLoot.forEach(pair -> {
                if (pair.getFirst() != null) {
                    ((LootPoolSingletonContainer.Builder)pair.getSecond()).fishofthieves$addWeight(100);
                    ((LootPoolSingletonContainer.Builder)pair.getSecond()).m_79080_(BaitAttachedCondition.baitMatches(ItemPredicate.Builder.m_45068_().m_204145_((TagKey)pair.getFirst()), EntityPredicate.Builder.m_36633_().m_36646_(EntityTypePredicate.m_37647_((EntityType)EntityType.f_20533_))));
                    builder.m_79076_((LootPoolEntryContainer.Builder)pair.getSecond());
                }
            });
        } else {
            fishLoot.forEach(pair -> builder.m_79076_((LootPoolEntryContainer.Builder)pair.getSecond()));
        }
        return builder;
    }

    public static LootPool.Builder getGuardianLoot(LootPool.Builder builder, boolean elder) {
        int weight = elder ? 3 : 2;
        return builder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL).m_79707_(weight).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_)))).m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.BATTLEGILL).m_79707_(weight).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_))));
    }

    public static LootPool.Builder getDolphinLoot(LootPool.Builder builder) {
        return builder.m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_)))).m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.ANCIENTSCALE).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_)))).m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.PLENTIFIN).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_)))).m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.WILDSPLASH).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_)))).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.STORMFISH).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_))).m_79080_(FOTLootItemConditions.THUNDERING));
    }

    public static LootPool.Builder getPolarBearLoot(LootPool.Builder builder) {
        return builder.m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.SPLASHTAIL).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_))).m_79707_(10).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.ANCIENTSCALE).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_))).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.PLENTIFIN).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_))).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.WILDSPLASH).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_))).m_79707_(6).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_79076_((LootPoolEntryContainer.Builder)FOTLootItem.lootTableItem((ItemLike)FOTItems.WRECKER).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_))).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_79076_(FOTLootItem.lootTableItem((ItemLike)FOTItems.STORMFISH).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityLootSubProvider.f_244460_))).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79080_(FOTLootItemConditions.THUNDERING));
    }

    public static LootPool.Builder getOceanRuinsArchaeologyLoot(LootPool.Builder builder) {
        return builder.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTBlocks.FISH_BONE)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.STORMFISH_POTTERY_SHERD)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.KRAKEN_POTTERY_SHERD)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.MEGALODON_POTTERY_SHERD)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.GREAT_MOUTH_POTTERY_SHERD));
    }

    public static LootPool.Builder getVillageFisherLoot(LootPool.Builder builder) {
        return builder.m_79076_((LootPoolEntryContainer.Builder)FOTTagEntry.expandTag(FOTTags.Items.THIEVES_FISH).m_79707_(1).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f))));
    }

    public static LootPool.Builder getBuriedTreasureLoot(LootPool.Builder builder) {
        return builder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)TagEntry.m_205095_(FOTTags.Items.COOKED_THIEVES_FISH).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)5.0f))));
    }

    public static LootPool.Builder getShipwreckSupplyLoot(LootPool.Builder builder) {
        return builder.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.BANANA).m_79707_(9).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)6.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.COCONUT).m_79707_(7).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.POMEGRANATE).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.MANGO).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f)))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.PINEAPPLE).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
    }

    public static LootPool.Builder getJungleTempleLoot(LootPool.Builder builder) {
        return builder.m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.BANANA).m_79707_(9).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)8.0f)))).m_79080_(LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(FOTBiomes.TROPICAL_ISLAND))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.POMEGRANATE).m_79707_(5).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)6.0f)))).m_79080_(LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(FOTBiomes.TROPICAL_ISLAND))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.MANGO).m_79707_(4).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)))).m_79080_(LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(FOTBiomes.TROPICAL_ISLAND))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)FOTItems.PINEAPPLE).m_79707_(2).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)))).m_79080_(LocationCheck.m_81725_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52656_(FOTBiomes.TROPICAL_ISLAND)));
    }
}

