/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item.trade;

import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.item.trade.RestockableMerchantOffer;
import com.stevekung.fishofthieves.registry.FOTMapDecorationTypes;
import com.stevekung.fishofthieves.registry.FOTPoiTypes;
import com.stevekung.fishofthieves.shoal.ShoalSpawner;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public record TreasuredFishMapForEmeralds(int farEmeraldCost, int nearEmeraldCost, String displayName, int maxUses, int villagerXp, int tier) implements VillagerTrades.ItemListing
{
    @Nullable
    public MerchantOffer m_213663_(Entity trader, RandomSource random) {
        Level level = trader.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Pair<ItemStack, Integer> pair = TreasuredFishMapForEmeralds.getTreasuredFishMap(serverLevel, trader, this.displayName, this.farEmeraldCost, this.nearEmeraldCost, this.tier);
        return pair == null ? null : new RestockableMerchantOffer(this.tier, new ItemStack((ItemLike)Items.f_42616_, ((Integer)pair.getSecond()).intValue()), new ItemStack((ItemLike)Items.f_42522_), (ItemStack)pair.getFirst(), this.maxUses, this.villagerXp, 0.2f);
    }

    @Nullable
    public static Pair<ItemStack, Integer> getTreasuredFishMap(ServerLevel serverLevel, Entity trader, String displayName, int tier) {
        return TreasuredFishMapForEmeralds.getTreasuredFishMap(serverLevel, trader, displayName, 14, 22, tier);
    }

    @Nullable
    public static Pair<ItemStack, Integer> getTreasuredFishMap(ServerLevel serverLevel, Entity trader, String displayName, int farEmeraldCost, int nearEmeraldCost, int tier) {
        Pair pair = null;
        Optional<BlockPos> farthest = ShoalSpawner.findFarthest(holder -> holder.m_203565_(FOTPoiTypes.NATURAL_SHOAL), trader.m_20183_(), 50, 100, serverLevel.m_8904_());
        if (farthest.isPresent()) {
            BlockPos blockPos = farthest.get();
            pair = Pair.of((Object)TreasuredFishMapForEmeralds.createTreasuredFishMap(serverLevel, blockPos, displayName, tier), (Object)farEmeraldCost);
            FishOfThieves.LOGGER.debug("Found farthest shoal at: {}", (Object)blockPos);
        } else {
            BlockPos attemptPos = ShoalSpawner.attemptSpawnShoal(serverLevel, trader.m_20183_(), 10);
            if (attemptPos != null) {
                pair = Pair.of((Object)TreasuredFishMapForEmeralds.createTreasuredFishMap(serverLevel, attemptPos, displayName, tier), (Object)farEmeraldCost);
                FishOfThieves.LOGGER.debug("Shoal spawn from map by fisherman at: {}", (Object)attemptPos);
            } else {
                Optional nearest = serverLevel.m_8904_().m_27192_(holder -> holder.m_203565_(FOTPoiTypes.NATURAL_SHOAL), trader.m_20183_(), 100, PoiManager.Occupancy.ANY);
                if (nearest.isPresent()) {
                    BlockPos blockPos = (BlockPos)nearest.get();
                    pair = Pair.of((Object)TreasuredFishMapForEmeralds.createTreasuredFishMap(serverLevel, blockPos, displayName, tier), (Object)nearEmeraldCost);
                    FishOfThieves.LOGGER.debug("Found nearest shoal at: {}", (Object)blockPos);
                }
            }
        }
        return pair;
    }

    private static ItemStack createTreasuredFishMap(ServerLevel serverLevel, BlockPos blockPos, String displayName, int tier) {
        ItemStack itemStack = MapItem.m_42886_((Level)serverLevel, (int)blockPos.m_123341_(), (int)blockPos.m_123343_(), (byte)1, (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)serverLevel, (ItemStack)itemStack);
        MapItemSavedData.m_77925_((ItemStack)itemStack, (BlockPos)blockPos, (String)"+", (MapDecoration.Type)FOTMapDecorationTypes.TREASURED_FISH);
        itemStack.m_41714_((Component)Component.m_237115_((String)displayName));
        Shoal.setTreasuredShoal((Level)serverLevel, blockPos, tier);
        return itemStack;
    }
}

