/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FOTSpawnEggItem
extends SpawnEggItem {
    private final ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey;

    public FOTSpawnEggItem(EntityType<? extends Mob> defaultType, int backgroundColor, int highlightColor, ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey, Item.Properties properties) {
        super(defaultType, backgroundColor, highlightColor, properties);
        this.resourceKey = resourceKey;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (level != null && itemStack.m_41782_()) {
            CompoundTag entityTag = itemStack.m_41737_("EntityTag");
            boolean trophy = entityTag.m_128471_("Trophy");
            boolean treasured = false;
            for (Holder.Reference entry : level.m_9598_().m_175515_(this.resourceKey).m_203611_().toList()) {
                if (!((AbstractFishVariant)entry.m_203334_()).isTreasured().isPresent() || !entityTag.m_128461_("variant").equals(entry.m_205785_().m_135782_().toString())) continue;
                tooltipComponents.add((Component)Component.m_237115_((String)(this.m_43228_(null).m_20675_() + "." + entry.m_205785_().m_135782_().m_135815_())).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD}));
                treasured = true;
            }
            if (!treasured) {
                tooltipComponents.add((Component)Component.m_237115_((String)(trophy ? "entity.fishofthieves.trophy" : "entity.fishofthieves.non_trophy")).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
        }
    }

    public static void addSpawnEgg(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output, Item item) {
        if (FishOfThieves.CONFIG.general.displayTrophySpawnEggInCreativeTab) {
            output.m_246342_(FOTSpawnEggItem.create(item, false));
            output.m_246342_(FOTSpawnEggItem.create(item, true));
        } else {
            output.m_246326_((ItemLike)item);
        }
        FOTSpawnEggItem spawnEgg = (FOTSpawnEggItem)item;
        for (Holder.Reference entry : itemDisplayParameters.f_268485_().m_255025_(spawnEgg.resourceKey).m_214062_().filter(holder -> ((AbstractFishVariant)holder.m_203334_()).isTreasured().isPresent()).toList()) {
            output.m_246342_(FOTSpawnEggItem.createTreasured(item, entry.m_205785_().m_135782_().toString()));
        }
    }

    private static ItemStack create(Item item, boolean trophy) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Trophy", trophy);
        itemStack.m_41784_().m_128365_("EntityTag", (Tag)compound);
        return itemStack;
    }

    private static ItemStack createTreasured(Item item, String variant) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Trophy", true);
        compound.m_128359_("variant", variant);
        itemStack.m_41784_().m_128365_("EntityTag", (Tag)compound);
        return itemStack;
    }
}

