/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.item.ResourceKeyHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FOTMobBucketItem
extends MobBucketItem
implements ResourceKeyHolder {
    private final EntityType<?> entityType;
    private final ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey;

    public FOTMobBucketItem(EntityType<?> entityType, Fluid fluid, SoundEvent soundEvent, ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey, Item.Properties properties) {
        super(entityType, fluid, soundEvent, properties);
        this.entityType = entityType;
        this.resourceKey = resourceKey;
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int slotId, boolean isSelected) {
        String registryKeyTag = this.resourceKey.m_135782_().m_135815_();
        if (!itemStack.m_41782_()) {
            String variant = ((Holder.Reference)level.m_9598_().m_175515_(this.resourceKey).m_203611_().toList().get(0)).m_205785_().m_135782_().toString();
            itemStack.m_41784_().m_128359_(registryKeyTag, variant);
        } else if (itemStack.m_41783_().m_128441_("CustomModelData") && (itemStack.m_41783_().m_128451_("CustomModelData") == 0 || FishOfThieves.CONFIG.general.enableFishItemDropWithVariant && itemStack.m_41783_().m_128441_("variant"))) {
            String variantOld = itemStack.m_41783_().m_128461_("variant");
            itemStack.m_41784_().m_128359_(registryKeyTag, variantOld);
            itemStack.m_41784_().m_128473_("CustomModelData");
            itemStack.m_41784_().m_128473_("variant");
        }
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (level != null && itemStack.m_41782_()) {
            for (Holder.Reference entry : level.m_9598_().m_175515_(this.resourceKey).m_203611_().toList()) {
                String key = entry.m_205785_().m_211136_().m_135815_();
                ResourceLocation variant = entry.m_205785_().m_135782_();
                if (!compoundTag.m_128461_(key).equals(variant.toString())) continue;
                boolean treasured = ((AbstractFishVariant)entry.m_203334_()).isTreasured().isPresent();
                MutableComponent type = this.createTooltip(variant.m_135815_(), treasured);
                if (!treasured && compoundTag.m_128471_("Trophy")) {
                    type.m_130946_(", ").m_7220_((Component)Component.m_237115_((String)"entity.fishofthieves.trophy"));
                }
                tooltipComponents.add((Component)type);
            }
        }
    }

    @Override
    public ResourceKey<? extends Registry<? extends AbstractFishVariant>> getResourceKey() {
        return this.resourceKey;
    }

    public static void addFishVariantsBucket(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output, Item item) {
        List list = itemDisplayParameters.f_268485_().m_255025_(((FOTMobBucketItem)item).resourceKey).m_214062_().toList();
        for (int i = 0; i < list.size() && (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab || i <= 0); ++i) {
            Holder.Reference entry = (Holder.Reference)list.get(i);
            String key = entry.m_205785_().m_211136_().m_135815_();
            ResourceLocation variant = entry.m_205785_().m_135782_();
            ItemStack itemStack = new ItemStack((ItemLike)item);
            itemStack.m_41784_().m_128359_(key, variant.toString());
            if (FishOfThieves.CONFIG.general.displayTrophyBucketInCreativeTab) {
                if (((AbstractFishVariant)entry.m_203334_()).isTreasured().isEmpty()) {
                    output.m_246342_(FOTMobBucketItem.create(item, key, variant.toString(), false));
                }
                output.m_246342_(FOTMobBucketItem.create(item, key, variant.toString(), true));
                continue;
            }
            output.m_246342_(FOTMobBucketItem.create(item, key, variant.toString(), null));
        }
    }

    private MutableComponent createTooltip(String variant, boolean treasured) {
        return Component.m_237115_((String)"entity.fishofthieves.%s.%s".formatted(BuiltInRegistries.f_256780_.m_7981_(this.entityType).m_135815_(), ResourceLocation.m_135820_((String)variant).m_135815_())).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, treasured ? ChatFormatting.GOLD : ChatFormatting.GRAY});
    }

    public static ItemStack create(Item item, String registryPath, String variant, Boolean trophy) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.m_41784_().m_128359_(registryPath, variant);
        if (!FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
            itemStack.m_41784_().m_128379_("creative", true);
        }
        if (trophy != null) {
            itemStack.m_41784_().m_128379_("Trophy", trophy.booleanValue());
        }
        return itemStack;
    }

    public static ItemStack createRandomBucket(Item item) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.m_41784_().m_128379_("creative", true);
        return itemStack;
    }
}

