/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.item.ResourceKeyHolder;
import com.stevekung.fishofthieves.spawn.SpawnConditionContext;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FOTItem
extends Item
implements ResourceKeyHolder {
    private final EntityType<?> entityType;
    private final ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey;

    public FOTItem(Item.Properties properties, EntityType<?> entityType, ResourceKey<? extends Registry<? extends AbstractFishVariant>> resourceKey) {
        super(properties);
        this.entityType = entityType;
        this.resourceKey = resourceKey;
    }

    public static void addFishVariants(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output, Item item) {
        List list = itemDisplayParameters.f_268485_().m_255025_(((FOTItem)item).resourceKey).m_214062_().toList();
        for (int i = 0; i < list.size() && (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab || i <= 0); ++i) {
            Holder.Reference entry = (Holder.Reference)list.get(i);
            String key = entry.m_205785_().m_211136_().m_135815_();
            ResourceLocation variant = entry.m_205785_().m_135782_();
            output.m_246342_(FOTItem.create(item, key, variant.toString()));
        }
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int slotId, boolean isSelected) {
        String registryKeyTag = this.resourceKey.m_135782_().m_135815_();
        if (!itemStack.m_41782_()) {
            String variant = ((Holder.Reference)level.m_9598_().m_175515_(this.resourceKey).m_203611_().toList().get(0)).m_205785_().m_135782_().toString();
            itemStack.m_41784_().m_128359_(registryKeyTag, variant);
        } else if (itemStack.m_41783_().m_128441_("CustomModelData") && (itemStack.m_41783_().m_128451_("CustomModelData") == 0 || FishOfThieves.CONFIG.general.enableFishItemDropWithVariant)) {
            int customModelData = itemStack.m_41783_().m_128451_("CustomModelData");
            String variant = ((Holder.Reference)level.m_9598_().m_175515_(this.resourceKey).m_203611_().toList().get(customModelData)).m_205785_().m_135782_().toString();
            itemStack.m_41784_().m_128359_(registryKeyTag, variant);
            itemStack.m_41784_().m_128473_("CustomModelData");
        }
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (level != null && itemStack.m_41782_()) {
            for (Holder.Reference entry : level.m_9598_().m_175515_(this.resourceKey).m_203611_().toList()) {
                String key = entry.m_205785_().m_211136_().m_135815_();
                ResourceLocation variant = entry.m_205785_().m_135782_();
                if (!compoundTag.m_128461_(key).equals(variant.toString())) continue;
                tooltipComponents.add((Component)Component.m_237115_((String)(this.entityType.m_20675_() + "." + variant.m_135815_())).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ((AbstractFishVariant)entry.m_203334_()).isTreasured().isPresent() ? ChatFormatting.GOLD : ChatFormatting.GRAY}));
            }
        }
    }

    @Override
    public ResourceKey<? extends Registry<? extends AbstractFishVariant>> getResourceKey() {
        return this.resourceKey;
    }

    public static ItemStack create(Item item, String registryPath, String variant) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.m_41784_().m_128359_(registryPath, variant);
        return itemStack;
    }

    public static ItemStack generateRandomFishVariantLootItem(ItemStack itemStack, ServerLevel level, @Nullable Vec3 vec3, RandomSource randomSource) {
        Item item = itemStack.m_41720_();
        if (item instanceof ResourceKeyHolder) {
            ResourceKeyHolder keyHolder = (ResourceKeyHolder)item;
            if (FishOfThieves.CONFIG.general.enableFishItemDropWithVariant) {
                if (vec3 != null) {
                    SpawnConditionContext context = SpawnSelectors.get(level, BlockPos.m_274446_((Position)vec3), randomSource);
                    Util.m_214676_(level.m_9598_().m_175515_(keyHolder.getResourceKey()).m_203611_().filter(holder -> ((AbstractFishVariant)holder.m_203334_()).getCondition().test(context)).toList(), (RandomSource)randomSource).ifPresent(holder -> itemStack.m_41784_().m_128359_(holder.m_205785_().m_211136_().m_135815_(), holder.m_205785_().m_135782_().toString()));
                }
            } else {
                Holder.Reference holder2 = (Holder.Reference)level.m_9598_().m_175515_(keyHolder.getResourceKey()).m_203611_().toList().get(0);
                itemStack.m_41784_().m_128359_(holder2.m_205785_().m_211136_().m_135815_(), holder2.m_205785_().m_135782_().toString());
            }
        }
        return itemStack;
    }
}

