/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.forge;

import com.stevekung.fishofthieves.entity.shoal.ShoalFishData;
import com.stevekung.fishofthieves.network.FOTClientPackets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class SyncClientShoalPacket {
    private final int entityId;
    private final List<ShoalFishData> shoalFishData;
    private final boolean forcedUpdate;

    public SyncClientShoalPacket(int entityId, List<ShoalFishData> shoalFishData, boolean forcedUpdate) {
        this.entityId = entityId;
        this.shoalFishData = shoalFishData;
        this.forcedUpdate = forcedUpdate;
    }

    public SyncClientShoalPacket(FriendlyByteBuf buf) {
        this.entityId = buf.m_130242_();
        this.shoalFishData = (List)buf.m_236838_(ArrayList::new, buf1 -> new ShoalFishData(buf1.m_130277_(), buf1.m_130259_(), buf1.m_130260_()));
        this.forcedUpdate = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_236828_(this.shoalFishData, (buff, shoalFish) -> {
            buff.m_130070_(shoalFish.id());
            buff.m_130077_(shoalFish.uuid());
            buff.m_130079_(shoalFish.data());
        });
        buf.writeBoolean(this.forcedUpdate);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        Minecraft minecraft = Minecraft.m_91087_();
        ctx.get().enqueueWork(() -> FOTClientPackets.syncClientShoalFish(minecraft, this.entityId, this.shoalFishData, this.forcedUpdate));
    }
}

