/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.trunkplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTTrunkPlacerTypes;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CoconutTrunkPlacer
extends TrunkPlacer {
    public static final Codec<CoconutTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(trunkPlacer -> trunkPlacer.f_70263_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(trunkPlacer -> trunkPlacer.f_70264_), (App)IntProvider.m_146545_((int)0, (int)16).fieldOf("medium_trunk_start").forGetter(trunkPlacer -> trunkPlacer.mediumTrunkStart), (App)IntProvider.m_146545_((int)0, (int)32).fieldOf("medium_trunk_height").forGetter(trunkPlacer -> trunkPlacer.mediumTrunkHeight), (App)Codec.BOOL.fieldOf("increase_medium_trunk_by_one").forGetter(trunkPlacer -> trunkPlacer.increaseMediumTrunkByOne), (App)BlockStateProvider.f_68747_.fieldOf("small_log").forGetter(trunkPlacer -> trunkPlacer.smallLog), (App)BlockStateProvider.f_68747_.fieldOf("medium_log").forGetter(trunkPlacer -> trunkPlacer.mediumLog), (App)BlockStateProvider.f_68747_.fieldOf("top_log").forGetter(trunkPlacer -> trunkPlacer.topLog)).apply((Applicative)instance, CoconutTrunkPlacer::new));
    private final IntProvider mediumTrunkStart;
    private final IntProvider mediumTrunkHeight;
    private final boolean increaseMediumTrunkByOne;
    private final BlockStateProvider smallLog;
    private final BlockStateProvider mediumLog;
    private final BlockStateProvider topLog;

    public CoconutTrunkPlacer(int baseHeight, int heightRandA, IntProvider mediumTrunkStart, IntProvider mediumTrunkHeight, boolean increaseMediumTrunkByOne, BlockStateProvider smallLog, BlockStateProvider mediumLog, BlockStateProvider topLog) {
        super(baseHeight, heightRandA, 0);
        this.mediumTrunkStart = mediumTrunkStart;
        this.mediumTrunkHeight = mediumTrunkHeight;
        this.increaseMediumTrunkByOne = increaseMediumTrunkByOne;
        this.smallLog = smallLog;
        this.mediumLog = mediumLog;
        this.topLog = topLog;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return FOTTrunkPlacerTypes.COCONUT_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        CoconutTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        int mediumTrunkStart = this.mediumTrunkStart.m_214085_(random);
        int mediumTrunkHeight = this.mediumTrunkHeight.m_214085_(random);
        if (this.increaseMediumTrunkByOne && mediumTrunkStart == mediumTrunkHeight) {
            ++mediumTrunkHeight;
        }
        for (int height = 0; height < freeTreeHeight; ++height) {
            this.placeLog(level, blockSetter, random, pos.m_6630_(height), config, mediumTrunkStart, mediumTrunkHeight, height, height == freeTreeHeight - 1);
        }
        return List.of(new FoliagePlacer.FoliageAttachment(pos.m_6630_(freeTreeHeight), 0, false));
    }

    private void placeLog(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config, int mediumTrunkStart, int mediumTrunkHeight, int height, boolean isTop) {
        if (this.m_213554_(level, pos)) {
            BlockState blockState = config.f_68185_.m_213972_(random, pos);
            int maxMediumTrunkHeight = mediumTrunkStart + mediumTrunkHeight;
            if (isTop) {
                blockState = this.topLog.m_213972_(random, pos);
            } else if (height >= mediumTrunkStart && height < maxMediumTrunkHeight) {
                blockState = this.mediumLog.m_213972_(random, pos);
            } else if (height >= maxMediumTrunkHeight) {
                blockState = this.smallLog.m_213972_(random, pos);
            }
            blockSetter.accept(pos, blockState);
        }
    }
}

