/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.trunkplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTTrunkPlacerTypes;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class BananaTrunkPlacer
extends TrunkPlacer {
    public static final Codec<BananaTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)16).fieldOf("base_height").forGetter(trunkPlacer -> trunkPlacer.f_70263_), (App)Codec.intRange((int)0, (int)12).fieldOf("height_rand_a").forGetter(trunkPlacer -> trunkPlacer.f_70264_), (App)BlockStateProvider.f_68747_.fieldOf("top_log").forGetter(trunkPlacer -> trunkPlacer.topLog)).apply((Applicative)instance, BananaTrunkPlacer::new));
    private final BlockStateProvider topLog;

    public BananaTrunkPlacer(int baseHeight, int heightRandA, BlockStateProvider topLog) {
        super(baseHeight, heightRandA, 0);
        this.topLog = topLog;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return FOTTrunkPlacerTypes.BANANA_TRUNK_PLACER;
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        BananaTrunkPlacer.m_226169_((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.m_7495_(), (TreeConfiguration)config);
        for (int height = 0; height < freeTreeHeight; ++height) {
            this.placeLog(level, blockSetter, random, pos.m_6630_(height), config, height == freeTreeHeight - 1);
        }
        return List.of(new FoliagePlacer.FoliageAttachment(pos.m_6630_(freeTreeHeight), 0, false));
    }

    private void placeLog(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, BlockPos pos, TreeConfiguration config, boolean isTop) {
        if (this.m_213554_(level, pos)) {
            BlockStateProvider log = isTop ? this.topLog : config.f_68185_;
            BlockState blockState = log.m_213972_(random, pos);
            blockSetter.accept(pos, blockState);
        }
    }
}

