/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.CoconutFruitBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.FOTTreeDecoratorTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CoconutDecorator
extends TreeDecorator {
    public static final Codec<CoconutDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("coconut_probability").forGetter(decorator -> Float.valueOf(decorator.coconutProbability)), (App)Codec.intRange((int)0, (int)16).fieldOf("y_to_grow_coconut_at").forGetter(decorator -> decorator.yToGrowCoconutAt)).apply((Applicative)instance, CoconutDecorator::new));
    private final float probability;
    private final float coconutProbability;
    private final int yToGrowCoconutAt;

    public CoconutDecorator(float probability, float coconutProbability, int yToGrowCoconutAt) {
        this.probability = probability;
        this.coconutProbability = coconutProbability;
        this.yToGrowCoconutAt = yToGrowCoconutAt;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return FOTTreeDecoratorTypes.COCONUT;
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource randomSource = context.m_226067_();
        if (!(randomSource.m_188501_() >= this.probability)) {
            ObjectArrayList list = context.m_226068_();
            int yAtStart = ((BlockPos)list.get(0)).m_123342_();
            Integer maxY = Collections.max(list.stream().map(blockPos -> blockPos.m_123342_() - yAtStart).toList());
            int yToGrowCoconutAt = maxY - this.yToGrowCoconutAt;
            list.stream().filter(blockPos -> blockPos.m_123342_() - yAtStart == yToGrowCoconutAt).findFirst().ifPresent(blockPos -> {
                Predicate<BlockState> canGrow = blockState -> blockState.m_204336_(FOTTags.Blocks.COCONUT_GROWABLE_LOG_SPAWNABLE);
                if (context.m_226058_().m_7433_(blockPos.m_7494_(), canGrow) && context.m_226058_().m_7433_(blockPos.m_7495_(), canGrow)) {
                    context.m_226061_(blockPos, FOTBlocks.COCONUT_FRUIT_GROWABLE_LOG.m_49966_());
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        Direction opposite;
                        BlockPos posAroundLog;
                        if (!(randomSource.m_188501_() <= this.coconutProbability) || !context.m_226059_(posAroundLog = blockPos.m_7918_((opposite = direction.m_122424_()).m_122429_(), 0, opposite.m_122431_()))) continue;
                        context.m_226061_(posAroundLog, (BlockState)((BlockState)FOTBlocks.COCONUT_FRUIT.m_49966_().m_61124_((Property)CoconutFruitBlock.AGE, (Comparable)Integer.valueOf(randomSource.m_188503_(3)))).m_61124_((Property)CoconutFruitBlock.f_54117_, (Comparable)direction));
                    }
                }
            });
        }
    }
}

