/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.BananaClusterGrowableStemBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTreeDecoratorTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.util.TriConsumer;

public class BananaDecorator
extends TreeDecorator {
    public static final Codec<BananaDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ripe_probability").forGetter(decorator -> Float.valueOf(decorator.ripeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("barely_ripe_probability").forGetter(decorator -> Float.valueOf(decorator.barelyRipeProbability)), (App)Codec.intRange((int)1, (int)16).fieldOf("max_banana_cluster").forGetter(decorator -> decorator.maxBananaCluster)).apply((Applicative)instance, BananaDecorator::new));
    private final float probability;
    private final float ripeProbability;
    private final float barelyRipeProbability;
    private final int maxBananaCluster;

    public BananaDecorator(float probability, float ripeProbability, float barelyRipeProbability, int maxBananaCluster) {
        this.probability = probability;
        this.ripeProbability = ripeProbability;
        this.barelyRipeProbability = barelyRipeProbability;
        this.maxBananaCluster = maxBananaCluster;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return FOTTreeDecoratorTypes.BANANA;
    }

    public void m_214187_(TreeDecorator.Context context) {
        LevelSimulatedReader level = context.m_226058_();
        RandomSource randomSource = context.m_226067_();
        ObjectArrayList list = context.m_226068_();
        int yAtStart = ((BlockPos)list.get(0)).m_123342_();
        Integer maxY = Collections.max(list.stream().map(blockPos -> blockPos.m_123342_() - yAtStart).toList());
        int yToGrowAt = maxY - 1;
        list.stream().filter(blockPos -> blockPos.m_123342_() - yAtStart == yToGrowAt).forEach(blockPos -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Direction opposite;
                BlockPos posAroundLog;
                if (randomSource.m_188501_() >= this.probability || !context.m_226059_(posAroundLog = blockPos.m_7918_((opposite = direction.m_122424_()).m_122429_(), 0, opposite.m_122431_())) || !level.m_7433_(posAroundLog.m_7494_(), blockState -> blockState.m_60713_(FOTBlocks.BANANA_LEAVES))) continue;
                BananaClusterGrowableStemBlock.growBananaBlossomOrCluster(opposite, level, (TriConsumer<BlockPos, BlockState, Integer>)((TriConsumer)(blockPos1, blockState, flags) -> context.m_226061_(blockPos1, blockState)), blockPosx -> level.m_142433_(blockPosx, fluidState -> fluidState.m_192917_((Fluid)Fluids.f_76193_)), randomSource, posAroundLog);
            }
        });
    }
}

