/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTBlockStateProviderTypes;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import org.jetbrains.annotations.Nullable;

public class RandomizedIntBooleanStateProvider
extends BlockStateProvider {
    public static final Codec<RandomizedIntBooleanStateProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("source").forGetter(provider -> provider.source), (App)Codec.STRING.fieldOf("integer_property").forGetter(provider -> provider.integerPropertyName), (App)IntProvider.f_146531_.fieldOf("integer_values").forGetter(provider -> provider.integerValues), (App)Codec.STRING.fieldOf("boolean_property").forGetter(provider -> provider.booleanPropertyName), (App)ConstantFloat.f_146452_.fieldOf("boolean_chance").forGetter(provider -> provider.booleanChance)).apply((Applicative)instance, RandomizedIntBooleanStateProvider::new));
    private final BlockStateProvider source;
    private final String integerPropertyName;
    @Nullable
    private IntegerProperty integerProperty;
    private final IntProvider integerValues;
    private final String booleanPropertyName;
    @Nullable
    private BooleanProperty booleanProperty;
    private final ConstantFloat booleanChance;

    public RandomizedIntBooleanStateProvider(BlockStateProvider source, IntegerProperty integerProperty, IntProvider integerValues, BooleanProperty booleanProperty, ConstantFloat booleanChance) {
        this.source = source;
        this.integerProperty = integerProperty;
        this.integerPropertyName = integerProperty.m_61708_();
        this.integerValues = integerValues;
        this.booleanProperty = booleanProperty;
        this.booleanPropertyName = booleanProperty.m_61708_();
        this.booleanChance = booleanChance;
        Collection collection = integerProperty.m_6908_();
        for (int i = integerValues.m_142739_(); i <= integerValues.m_142737_(); ++i) {
            if (collection.contains(i)) continue;
            throw new IllegalArgumentException("Property value out of range: " + integerProperty.m_61708_() + ": " + i);
        }
    }

    public RandomizedIntBooleanStateProvider(BlockStateProvider source, String integerPropertyName, IntProvider integerValues, String booleanPropertyName, ConstantFloat booleanChance) {
        this.source = source;
        this.integerPropertyName = integerPropertyName;
        this.integerValues = integerValues;
        this.booleanPropertyName = booleanPropertyName;
        this.booleanChance = booleanChance;
    }

    protected BlockStateProviderType<?> m_5923_() {
        return FOTBlockStateProviderTypes.RANDOMIZED_INT_BOOLEAN_STATE_PROVIDER;
    }

    public BlockState m_213972_(RandomSource random, BlockPos pos) {
        BlockState blockState = this.source.m_213972_(random, pos);
        if (this.integerProperty == null || !blockState.m_61138_((Property)this.integerProperty)) {
            this.integerProperty = RandomizedIntBooleanStateProvider.findProperty(blockState, this.integerPropertyName, IntegerProperty.class);
        }
        if (this.booleanProperty == null || !blockState.m_61138_((Property)this.booleanProperty)) {
            this.booleanProperty = RandomizedIntBooleanStateProvider.findProperty(blockState, this.booleanPropertyName, BooleanProperty.class);
        }
        return (BlockState)((BlockState)blockState.m_61124_((Property)this.integerProperty, (Comparable)Integer.valueOf(this.integerValues.m_214085_(random)))).m_61124_((Property)this.booleanProperty, (Comparable)Boolean.valueOf(random.m_188501_() < this.booleanChance.m_146474_()));
    }

    private static <T extends Property<?>> T findProperty(BlockState state, String propertyName, Class<T> propertyClass) {
        Collection collection = state.m_61147_();
        Optional<Property> optional = collection.stream().filter(property -> property.m_61708_().equals(propertyName)).filter(propertyClass::isInstance).map(propertyClass::cast).findAny();
        return (T)optional.orElseThrow(() -> new IllegalArgumentException("Illegal property: " + propertyName));
    }
}

