/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTFoliagePlacerTypes;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class CoconutFrondsPlacer
extends FoliagePlacer {
    public static final Codec<CoconutFrondsPlacer> CODEC = RecordCodecBuilder.create(instance -> CoconutFrondsPlacer.frondsPart(instance).apply((Applicative)instance, CoconutFrondsPlacer::new));
    final int height;
    final int maxLeavesDistanceFromLocalY;
    final BlockStateProvider topLeavesState;
    final BlockStateProvider middleLeavesState;
    final BlockStateProvider tailLeavesState;
    final List<Pair<Integer, Integer>> reduceLeavesDistance;

    static <P extends CoconutFrondsPlacer> Products.P6<RecordCodecBuilder.Mu<P>, Integer, Integer, BlockStateProvider, BlockStateProvider, BlockStateProvider, List<Pair<Integer, Integer>>> frondsPart(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)Codec.intRange((int)0, (int)8).fieldOf("height").forGetter(placer -> placer.height)).and((App)Codec.intRange((int)0, (int)8).fieldOf("max_leaves_distance_from_local_y").forGetter(placer -> placer.maxLeavesDistanceFromLocalY)).and((App)BlockStateProvider.f_68747_.fieldOf("top_leaves_state").forGetter(placer -> placer.topLeavesState)).and((App)BlockStateProvider.f_68747_.fieldOf("middle_leaves_state").forGetter(placer -> placer.middleLeavesState)).and((App)BlockStateProvider.f_68747_.fieldOf("tail_leaves_state").forGetter(placer -> placer.tailLeavesState)).and((App)Codec.mapPair((MapCodec)Codec.intRange((int)0, (int)16).fieldOf("at_tree_height"), (MapCodec)Codec.intRange((int)0, (int)8).fieldOf("reduce_by")).codec().listOf().optionalFieldOf("reduce_leaves_distance", List.of()).forGetter(placer -> placer.reduceLeavesDistance));
    }

    public CoconutFrondsPlacer(int height, int maxLeavesDistanceFromLocalY, BlockStateProvider topLeavesState, BlockStateProvider middleLeavesState, BlockStateProvider tailLeavesState, List<Pair<Integer, Integer>> reduceLeavesDistance) {
        super((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0));
        this.height = height;
        this.maxLeavesDistanceFromLocalY = maxLeavesDistanceFromLocalY;
        this.topLeavesState = topLeavesState;
        this.middleLeavesState = middleLeavesState;
        this.tailLeavesState = tailLeavesState;
        this.reduceLeavesDistance = reduceLeavesDistance;
    }

    @SafeVarargs
    public CoconutFrondsPlacer(int height, int maxLeavesDistanceFromLocalY, BlockStateProvider topLeavesState, BlockStateProvider middleLeavesState, BlockStateProvider tailLeavesState, Pair<Integer, Integer> ... reduceLeavesDistance) {
        this(height, maxLeavesDistanceFromLocalY, topLeavesState, middleLeavesState, tailLeavesState, Arrays.stream(reduceLeavesDistance).toList());
    }

    protected FoliagePlacerType<?> m_5897_() {
        return FOTFoliagePlacerTypes.COCONUT_FRONDS_PLACER;
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.m_161451_();
        if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            return;
        }
        for (int localY = offset; localY >= offset - foliageHeight; --localY) {
            if (localY == 0) {
                this.placeTopLeaves(level, pos, random, blockSetter);
                continue;
            }
            int maxLeavesDistanceFromLocalY = this.maxLeavesDistanceFromLocalY - localY + 1;
            for (Pair<Integer, Integer> pair : this.reduceLeavesDistance) {
                if (maxFreeTreeHeight != (Integer)pair.getFirst()) continue;
                maxLeavesDistanceFromLocalY -= ((Integer)pair.getSecond()).intValue();
            }
            this.placeLeavesHorizontalDirections(level, pos, random, config, blockSetter, maxLeavesDistanceFromLocalY, localY);
        }
    }

    public int m_214116_(RandomSource random, int height, TreeConfiguration config) {
        return this.height;
    }

    protected boolean m_214203_(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && (random.m_188503_(2) == 0 || localY == 0);
    }

    private void placeTopLeaves(LevelSimulatedReader level, BlockPos blockPos, RandomSource random, FoliagePlacer.FoliageSetter blockSetter) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)blockPos)) {
            BlockState blockState = this.topLeavesState.m_213972_(random, blockPos);
            if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(blockPos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
            }
            blockSetter.m_271838_(blockPos, blockState);
        }
    }

    private void placeLeavesHorizontalDirections(LevelSimulatedReader level, BlockPos blockPos, RandomSource random, TreeConfiguration config, FoliagePlacer.FoliageSetter blockSetter, int maxLeavesDistanceFromLocalY, int localY) {
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
        block0: for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState middleLeavesState;
            Direction opposite = direction.m_122424_();
            BlockState leavesBlockState = config.f_161213_.m_213972_(random, blockPos);
            if (leavesBlockState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                leavesBlockState = (BlockState)leavesBlockState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)opposite);
            }
            if (leavesBlockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                leavesBlockState = (BlockState)leavesBlockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(blockPos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
            }
            if (maxLeavesDistanceFromLocalY == 1) {
                BlockPos posAroundLog = mutableBlockPos.m_7918_(opposite.m_122429_(), localY, opposite.m_122431_());
                if (!this.isAir(level, posAroundLog)) continue;
                blockSetter.m_271838_(posAroundLog, leavesBlockState);
                continue;
            }
            BlockState tailLeavesState = this.tailLeavesState.m_213972_(random, blockPos);
            if (tailLeavesState.m_61138_((Property)BlockStateProperties.f_61374_)) {
                tailLeavesState = (BlockState)tailLeavesState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)opposite);
            }
            if ((middleLeavesState = this.middleLeavesState.m_213972_(random, blockPos)).m_61138_((Property)BlockStateProperties.f_61374_)) {
                middleLeavesState = (BlockState)middleLeavesState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)opposite);
            }
            for (int i = 1; i <= maxLeavesDistanceFromLocalY; ++i) {
                BlockPos posAroundLog = mutableBlockPos.m_7918_(opposite.m_122429_() * i, localY, opposite.m_122431_() * i);
                if (this.isAir(level, posAroundLog)) {
                    if (i > 1 && i < maxLeavesDistanceFromLocalY) {
                        blockSetter.m_271838_(posAroundLog, middleLeavesState);
                        continue;
                    }
                    if (i == maxLeavesDistanceFromLocalY) {
                        blockSetter.m_271838_(posAroundLog, tailLeavesState);
                        continue;
                    }
                    blockSetter.m_271838_(posAroundLog, leavesBlockState);
                    continue;
                }
                BlockPos previousLeavesPos = mutableBlockPos.m_7918_(opposite.m_122429_() * (i - 1), localY, opposite.m_122431_() * (i - 1));
                if (!level.m_7433_(previousLeavesPos, middleLeavesState::equals)) continue block0;
                blockSetter.m_271838_(previousLeavesPos, tailLeavesState);
                continue block0;
            }
        }
    }

    private boolean isAir(LevelSimulatedReader level, BlockPos blockPos) {
        return level.m_7433_(blockPos, BlockBehaviour.BlockStateBase::m_60795_);
    }
}

