/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.foliageplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.block.BananaLeavesBlock;
import com.stevekung.fishofthieves.registry.FOTFoliagePlacerTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BananaLeavesPlacer
extends FoliagePlacer {
    public static final Codec<BananaLeavesPlacer> CODEC = RecordCodecBuilder.create(instance -> BananaLeavesPlacer.frondsPart(instance).apply((Applicative)instance, BananaLeavesPlacer::new));
    final float oneLeavesChance;
    final BlockStateProvider topLeavesState;
    final BlockStateProvider tailLeavesState;

    static <P extends BananaLeavesPlacer> Products.P3<RecordCodecBuilder.Mu<P>, Float, BlockStateProvider, BlockStateProvider> frondsPart(RecordCodecBuilder.Instance<P> instance) {
        return instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("one_leaves_chance").forGetter(placer -> Float.valueOf(placer.oneLeavesChance))).and((App)BlockStateProvider.f_68747_.fieldOf("top_leaves_state").forGetter(placer -> placer.topLeavesState)).and((App)BlockStateProvider.f_68747_.fieldOf("tail_leaves_state").forGetter(placer -> placer.tailLeavesState));
    }

    public BananaLeavesPlacer(float oneLeavesChance, BlockStateProvider topLeavesState, BlockStateProvider tailLeavesState) {
        super((IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)0));
        this.oneLeavesChance = oneLeavesChance;
        this.topLeavesState = topLeavesState;
        this.tailLeavesState = tailLeavesState;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return FOTFoliagePlacerTypes.BANANA_LEAVES_PLACER;
    }

    protected void m_213633_(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos pos = attachment.m_161451_();
        if (!TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)pos)) {
            return;
        }
        for (int localY = offset; localY >= offset - 1; --localY) {
            if (localY == 0) {
                this.placeTopLeaves(level, pos, random, blockSetter);
                continue;
            }
            BlockPos.MutableBlockPos mutableBlockPos = pos.m_122032_();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                Direction opposite = direction.m_122424_();
                BlockPos posAroundLog = mutableBlockPos.m_7918_(opposite.m_122429_(), localY, opposite.m_122431_());
                if (!this.isAir(level, posAroundLog) || !this.isAir(level, posAroundLog.m_121945_(opposite))) continue;
                boolean singleLeaves = random.m_188501_() < this.oneLeavesChance;
                blockSetter.m_271838_(posAroundLog, this.applyAdditionalState(level, posAroundLog, config.f_161213_.m_213972_(random, pos), opposite, singleLeaves));
                blockSetter.m_271838_(posAroundLog.m_121945_(opposite), this.applyAdditionalState(level, posAroundLog, this.tailLeavesState.m_213972_(random, pos), opposite, singleLeaves));
            }
        }
    }

    public int m_214116_(RandomSource random, int height, TreeConfiguration config) {
        return 1;
    }

    protected boolean m_214203_(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return localX == range && localZ == range && (random.m_188503_(2) == 0 || localY == 0);
    }

    private boolean isAir(LevelSimulatedReader level, BlockPos blockPos) {
        return level.m_7433_(blockPos, BlockBehaviour.BlockStateBase::m_60795_);
    }

    private void placeTopLeaves(LevelSimulatedReader level, BlockPos blockPos, RandomSource random, FoliagePlacer.FoliageSetter blockSetter) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)blockPos)) {
            BlockState blockState = this.topLeavesState.m_213972_(random, blockPos);
            if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(blockPos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
            }
            blockSetter.m_271838_(blockPos, blockState);
        }
    }

    private BlockState applyAdditionalState(LevelSimulatedReader level, BlockPos blockPos, BlockState blockState, Direction opposite, boolean singleLeaves) {
        if (blockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
            blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(level.m_142433_(blockPos, fluidState -> fluidState.m_164512_((Fluid)Fluids.f_76193_))));
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61374_)) {
            blockState = (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)opposite);
        }
        if (blockState.m_61138_((Property)BananaLeavesBlock.COUNT)) {
            blockState = (BlockState)blockState.m_61124_((Property)BananaLeavesBlock.COUNT, (Comparable)Integer.valueOf(singleLeaves ? 1 : 2));
        }
        return blockState;
    }
}

