/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.shoal;

import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.block.ShoalBlock;
import com.stevekung.fishofthieves.entity.FishData;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.shoal.ShoalFishData;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Shoal
extends Entity {
    private static final List<EntityType<?>> COMMON_FISH = List.of(FOTEntities.SPLASHTAIL, FOTEntities.PONDIE, FOTEntities.ANCIENTSCALE, FOTEntities.ISLEHOPPER, FOTEntities.PLENTIFIN, FOTEntities.WILDSPLASH);
    private static final List<EntityType<?>> TIER_1_FISH_QUEST = List.of(FOTEntities.PONDIE, FOTEntities.ANCIENTSCALE, FOTEntities.WRECKER, FOTEntities.DEVILFISH, FOTEntities.ISLEHOPPER);
    private static final List<EntityType<?>> TIER_2_FISH_QUEST = List.of(FOTEntities.SPLASHTAIL, FOTEntities.WILDSPLASH, FOTEntities.BATTLEGILL, FOTEntities.PLENTIFIN, FOTEntities.STORMFISH);
    private static final EntityDataAccessor<Boolean> TREASURED = SynchedEntityData.m_135353_(Shoal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final String SHOAL_FISH_TAG = "shoal_fish";
    public static final String LIFETIME_TAG = "lifetime";
    public static final String NATURAL_TAG = "natural";
    public static final String TREASURED_TAG = "treasured";
    public static final String PARTICIPATES_TAG = "participates";
    public static final String FILLED_MAP_TREASURED_FISH = "filled_map.fishofthieves_treasured_fish";
    private final List<ShoalFishData> shoalFishData = new ArrayList<ShoalFishData>();
    private final Set<UUID> participates = new HashSet<UUID>();
    private long expiredAt = -1L;
    private List<LivingEntity> shoalFishClient = new ArrayList<LivingEntity>();

    public Shoal(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(TREASURED, (Object)false);
    }

    protected void m_7378_(CompoundTag compound) {
        this.shoalFishData.clear();
        ListTag shoalFishListTag = compound.m_128437_(SHOAL_FISH_TAG, 10);
        for (int i = 0; i < shoalFishListTag.size(); ++i) {
            CompoundTag compoundTag = shoalFishListTag.m_128728_(i);
            if (!compoundTag.m_128425_("id", 8) || compoundTag.m_128461_("id").isEmpty()) {
                return;
            }
            UUID uuid = compoundTag.m_128403_("uuid") ? compoundTag.m_128342_("uuid") : UUID.randomUUID();
            this.shoalFishData.add(new ShoalFishData(compoundTag.m_128461_("id"), uuid, compoundTag.m_128469_("data")));
        }
        if (compound.m_128425_(LIFETIME_TAG, 4)) {
            this.expiredAt = compound.m_128454_(LIFETIME_TAG);
        }
        if (compound.m_128425_(TREASURED_TAG, 1)) {
            this.setTreasured(compound.m_128471_(TREASURED_TAG));
        }
        ListTag participatesListTag = compound.m_128437_(PARTICIPATES_TAG, 10);
        for (int i = 0; i < participatesListTag.size(); ++i) {
            CompoundTag compoundTag = participatesListTag.m_128728_(i);
            if (!compoundTag.m_128403_("UUID")) continue;
            this.participates.add(compoundTag.m_128342_("UUID"));
        }
        if (!this.m_9236_().m_5776_() && compound.m_128441_(NATURAL_TAG) && compound.m_128471_(NATURAL_TAG)) {
            this.createNaturalSpawn(false);
        }
        FOTPlatform.syncClientShoalFish(this, false);
    }

    protected void m_7380_(CompoundTag compound) {
        ListTag shoalFishListTag = new ListTag();
        for (ShoalFishData fish : this.shoalFishData) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("id", fish.id());
            compoundTag.m_128362_("uuid", fish.uuid());
            compoundTag.m_128365_("data", (Tag)fish.data());
            shoalFishListTag.add((Object)compoundTag);
        }
        compound.m_128365_(SHOAL_FISH_TAG, (Tag)shoalFishListTag);
        if (this.expiredAt > 0L) {
            compound.m_128356_(LIFETIME_TAG, this.expiredAt);
        }
        compound.m_128379_(TREASURED_TAG, this.isTreasured());
        ListTag participatesListTag = new ListTag();
        for (UUID uuid : this.participates) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128362_("UUID", uuid);
            participatesListTag.add((Object)compoundTag);
        }
        compound.m_128365_(PARTICIPATES_TAG, (Tag)participatesListTag);
    }

    public boolean m_271807_() {
        return false;
    }

    public boolean m_7313_(Entity entity) {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            int soundChance;
            BlockState blockState = this.m_9236_().m_8055_(this.m_20183_());
            boolean canSurvive = ShoalBlock.canSurvive((LevelReader)this.m_9236_(), this.m_20183_());
            if ((this.m_9236_().m_46467_() % 20L == 0L && !canSurvive || !this.isTreasured() && this.m_9236_().m_46467_() >= this.expiredAt || this.shoalFishData.isEmpty() || !blockState.m_60713_(FOTBlocks.SHOAL)) && !this.m_20147_()) {
                this.destroy();
            }
            if (this.f_19796_.m_188503_(4) == 0) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_(), this.m_20227_(0.8), this.m_20189_(), 10, (double)(this.m_20205_() / 3.0f), (double)(this.m_20206_() / 5.0f), (double)(this.m_20205_() / 3.0f), 0.0);
            }
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, (double)(this.m_20205_() / 2.0f), (double)(this.m_20206_() / 5.0f), (double)(this.m_20205_() / 2.0f), 0.0);
            if (!this.shoalFishData.isEmpty() && this.f_19796_.m_188503_(Math.max(15, soundChance = 40 / this.shoalFishData.size())) == 0) {
                this.m_5496_(SoundEvents.f_11938_, 0.1f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.4f);
            }
        }
    }

    public void m_6478_(MoverType type, Vec3 pos) {
        if (type == MoverType.PISTON) {
            this.destroy();
        }
        super.m_6478_(type, pos);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        FOTPlatform.requestServerShoalFish(this);
    }

    public void m_6074_() {
        super.m_6074_();
        this.destroyShoalBlock();
    }

    public boolean m_6783_(double distance) {
        double d0 = 64.0 * Shoal.m_20150_();
        return distance < d0 * d0;
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (damageSource.m_269533_(DamageTypeTags.f_268415_)) {
            this.destroy();
        }
        return super.m_6469_(damageSource, amount);
    }

    public void setTreasured(boolean treasured) {
        this.m_20088_().m_135381_(TREASURED, (Object)treasured);
    }

    public boolean isTreasured() {
        return (Boolean)this.m_20088_().m_135370_(TREASURED);
    }

    public void destroy() {
        this.m_146870_();
        this.destroyShoalBlock();
    }

    public void syncClientShoalFish(List<ShoalFishData> shoalFishData, boolean forcedUpdate) {
        block3: {
            block2: {
                if (this.shoalFishClient.isEmpty() || this.shoalFishClient.size() != shoalFishData.size()) break block2;
                if (!forcedUpdate) break block3;
            }
            this.shoalFishClient = shoalFishData.stream().map(shoalFishData1 -> {
                CompoundTag compoundTag = shoalFishData1.data();
                compoundTag.m_128359_("id", shoalFishData1.id());
                return EntityType.m_20645_((CompoundTag)compoundTag, (Level)this.m_9236_(), Function.identity());
            }).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).peek(livingEntity -> {
                livingEntity.f_19798_ = true;
            }).toList();
        }
    }

    public List<ShoalFishData> getShoalFish() {
        return this.shoalFishData;
    }

    @Nullable
    public LivingEntity getRandomFishInShoal() {
        ShoalFishData shoalFish = (ShoalFishData)Util.m_214621_(this.shoalFishData, (RandomSource)this.f_19796_);
        UUID uuid = shoalFish.uuid();
        CompoundTag compoundTag = shoalFish.data();
        compoundTag.m_128359_("id", shoalFish.id());
        Entity entity = EntityType.m_20645_((CompoundTag)compoundTag, (Level)this.m_9236_(), Function.identity());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.shoalFishData.removeIf(shoalFishData1 -> shoalFishData1.uuid().equals(uuid));
            FOTPlatform.syncClientShoalFish(this, false);
            if (this.shoalFishData.isEmpty()) {
                for (UUID participate : this.participates) {
                    Player player = this.m_9236_().m_46003_(participate);
                    if (!(player instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    FOTCriteriaTriggers.PARTICIPATE_SHOAL.trigger(serverPlayer);
                }
                this.destroy();
            }
            if (livingEntity instanceof Mob) {
                ThievesFish thievesFish;
                Mob mob = (Mob)livingEntity;
                if (livingEntity instanceof ThievesFish && (thievesFish = (ThievesFish)livingEntity).isTreasured()) {
                    mob.m_21530_();
                }
            }
            return livingEntity;
        }
        FishOfThieves.LOGGER.warn("ShoalFishData with entity id {} is not a living entity", (Object)shoalFish.id());
        return null;
    }

    public List<LivingEntity> getShoalFishClient() {
        return this.shoalFishClient;
    }

    public void createNaturalSpawn(boolean clientSync) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ArrayList commonFish = new ArrayList(COMMON_FISH);
        if (this.m_9236_().m_46470_()) {
            commonFish.add(FOTEntities.STORMFISH);
        }
        for (EntityType<?> entityType : Shoal.pickRandom(commonFish, 3)) {
            Entity entity = entityType.m_20615_((Level)serverLevel);
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            CompoundTag compoundTag = new CompoundTag();
            mob.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(entity.m_20183_()), MobSpawnType.NATURAL, null, null);
            CompoundTag tempTag = mob.m_20240_(new CompoundTag());
            if (mob instanceof ThievesFish) {
                compoundTag.m_128359_("variant", tempTag.m_128461_("variant"));
                compoundTag.m_128379_("Trophy", this.f_19796_.m_188501_() < FishOfThieves.CONFIG.spawnRate.trophyProbability);
            }
            this.shoalFishData.add(new ShoalFishData(BuiltInRegistries.f_256780_.m_7981_((Object)mob.m_6095_()).toString(), UUID.randomUUID(), compoundTag));
        }
        this.expiredAt = this.m_9236_().m_46467_() + (long)FishOfThieves.CONFIG.shoal.maxLifetimeDay * 24000L;
        if (clientSync) {
            FOTPlatform.syncClientShoalFish(this, false);
        }
    }

    public void createTreasuredSpawn(int tier) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int prevShoalSize = this.shoalFishData.size();
        this.shoalFishData.clear();
        for (EntityType<?> entityType : Shoal.pickRandom(tier == 1 ? TIER_1_FISH_QUEST : TIER_2_FISH_QUEST, prevShoalSize)) {
            Entity entity = entityType.m_20615_((Level)serverLevel);
            if (!(entity instanceof ThievesFish)) continue;
            ThievesFish thievesFish = (ThievesFish)entity;
            CompoundTag compoundTag = new CompoundTag();
            ResourceLocation key = (ResourceLocation)Util.m_214621_(thievesFish.getRegistry().m_6579_().stream().filter(entry -> ((FishData)entry.getValue()).isTreasured().isPresent()).map(entry -> ((ResourceKey)entry.getKey()).m_135782_()).toList(), (RandomSource)this.f_19796_);
            compoundTag.m_128359_("variant", key.toString());
            compoundTag.m_128379_("Trophy", true);
            this.shoalFishData.add(new ShoalFishData(BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).toString(), UUID.randomUUID(), compoundTag));
        }
        this.expiredAt = -1L;
        FOTPlatform.syncClientShoalFish(this, true);
    }

    public void addParticipatePlayer(UUID uuid) {
        this.participates.add(uuid);
    }

    public void setExpiredAt(long expiredAt) {
        this.expiredAt = expiredAt;
    }

    public static void setTreasuredShoal(Level level, BlockPos blockPos, int tier) {
        level.m_7731_(blockPos, (BlockState)FOTBlocks.SHOAL.m_49966_().m_61124_((Property)ShoalBlock.TREASURED, (Comparable)Boolean.valueOf(true)), 2);
        List shoals = level.m_45976_(Shoal.class, new AABB(blockPos).m_82400_(1.0));
        if (!shoals.isEmpty()) {
            Shoal shoal = (Shoal)((Object)shoals.get(0));
            shoal.createTreasuredSpawn(tier);
            shoal.setTreasured(true);
        }
    }

    private void destroyShoalBlock() {
        BlockPos blockPos = this.m_20183_();
        BlockState blockState = this.m_9236_().m_8055_(blockPos);
        if (blockState.m_60713_(FOTBlocks.SHOAL)) {
            this.m_9236_().m_7731_(blockPos, Blocks.f_49990_.m_49966_(), 2);
        }
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), 10, (double)(this.m_20205_() / 5.0f), (double)(this.m_20206_() / 2.0f), (double)(this.m_20205_() / 5.0f), 0.0);
            this.m_5496_(FOTSoundEvents.SHOAL_DEPLETE, 1.0f, 0.75f);
        }
        if (FishOfThieves.CONFIG.debug.spawnBeaconAtShoal && FOTPlatform.isDevelopment()) {
            for (BlockPos blockPos1 : BlockPos.m_121940_((BlockPos)blockPos.m_7918_(-1, -4, -1), (BlockPos)blockPos.m_7918_(1, -4, 1))) {
                if (!this.m_9236_().m_8055_(blockPos1).m_60713_(Blocks.f_50075_)) continue;
                this.m_9236_().m_7731_(blockPos1, Blocks.f_49990_.m_49966_(), 3);
            }
            if (this.m_9236_().m_8055_(blockPos.m_6625_(3)).m_60713_(Blocks.f_50273_)) {
                this.m_9236_().m_7731_(blockPos.m_6625_(3), Blocks.f_49990_.m_49966_(), 3);
            }
        }
    }

    private static List<? extends EntityType<?>> pickRandom(List<EntityType<?>> list, int count) {
        return new Random().ints(0, list.size()).distinct().limit(count).mapToObj(list::get).toList();
    }
}

