/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.ai.WreckerAi;
import com.stevekung.fishofthieves.entity.variant.WreckerVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.WreckerVariants;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;

public class Wrecker
extends AbstractThievesFish<WreckerVariant> {
    private static final EntityDataAccessor<WreckerVariant> VARIANT = SynchedEntityData.m_135353_(Wrecker.class, FOTDataSerializers.WRECKER_VARIANT);
    private static final List<SensorType<? extends Sensor<? super Wrecker>>> SENSOR_TYPES = List.of(SensorType.f_26811_, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, SensorType.f_26814_, FOTSensorTypes.EARTHWORMS_THIEVES_FISH_TEMPTATIONS, FOTSensorTypes.NEAREST_WRECKER_LOCATED, FOTSensorTypes.NEAREST_MAGMA_BLOCK, FOTSensorTypes.WRECKER_ATTACKABLES, FOTSensorTypes.LOW_BRIGHTNESS);
    private static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_148204_, MemoryModuleType.f_148205_, MemoryModuleType.f_26326_, MemoryModuleType.f_26377_, MemoryModuleType.f_26356_, FOTMemoryModuleTypes.NEAREST_WRECKER_LOCATED, FOTMemoryModuleTypes.NEAREST_LOW_BRIGHTNESS, MemoryModuleType.f_148194_, MemoryModuleType.f_26372_, MemoryModuleType.f_26373_, MemoryModuleType.f_148197_, MemoryModuleType.f_148198_, MemoryModuleType.f_148196_, MemoryModuleType.f_26375_, MemoryModuleType.f_217768_, MemoryModuleType.f_148199_, FOTMemoryModuleTypes.BREACHED_TICK);

    public Wrecker(EntityType<? extends Wrecker> entityType, Level level) {
        super(entityType, level);
    }

    protected Brain.Provider<Wrecker> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return WreckerAi.makeBrain((Brain<Wrecker>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Wrecker> m_6274_() {
        return super.m_6274_();
    }

    @Override
    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("wreckerBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_6182_("wreckerActivityUpdate");
        WreckerAi.updateActivity(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public double m_142593_(LivingEntity entity) {
        return 0.5 + (double)entity.m_20205_() * 2.0;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)WreckerVariants.ROSE);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        WreckerAi.initMemories(this);
    }

    @Override
    public Registry<WreckerVariant> getRegistry() {
        return FOTRegistry.WRECKER_VARIANT;
    }

    @Override
    public void setVariant(WreckerVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public WreckerVariant getVariant() {
        return (WreckerVariant)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public Holder<WreckerVariant> getSpawnVariant(boolean creativeBucket) {
        return this.getSpawnVariant((LivingEntity)this, FOTTags.FishVariant.DEFAULT_WRECKER_SPAWNS, WreckerVariants.ROSE, creativeBucket);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FOTItems.WRECKER_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.WRECKER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.WRECKER_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.WRECKER_FLOP;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.275f, (float)0.25f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.34f : 0.175f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, dataTag);
        if (this.isTrophy()) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.5);
        }
        return spawnData;
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.m_21051_(Attributes.f_22281_).m_22100_(2.5);
        }
        super.setTrophy(trophy);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return EARTHWORMS_FOOD.test(itemStack);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean isWater = level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockPos).m_60713_(Blocks.f_49990_);
        return isWater && TerrainUtils.isInFeature(level.m_6018_(), blockPos, FOTTags.Structures.WRECKERS_SPAWN_IN);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22282_, 0.01);
    }

    @Nullable
    public static BlockPos getNearestShipwreckOrRuinedPortalPos(ServerLevel level, BlockPos pos, ChunkPos chunkPos) {
        Registry structureRegistry = level.m_9598_().m_175515_(Registries.f_256944_);
        Optional structureHolderSet = structureRegistry.m_203431_(FOTTags.Structures.WRECKERS_LOCATED);
        int structureRange = 32;
        int distFromStructure = Integer.MAX_VALUE;
        if (structureHolderSet.isPresent()) {
            Structure structure1 = null;
            ChunkPos chunkPos1 = null;
            for (Holder structureHolder : (HolderSet.Named)structureHolderSet.get()) {
                Structure structure = (Structure)structureHolder.m_203334_();
                Map structureRefMap = level.m_46819_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62315_).m_62769_();
                Optional<Structure> optional = structureRefMap.keySet().stream().filter(structurex -> structurex.equals(structure)).findAny();
                if (!optional.isPresent()) continue;
                structure1 = optional.get();
                chunkPos1 = chunkPos;
            }
            if (structure1 != null) {
                for (StructureStart structureStart : level.m_215010_().m_220504_(SectionPos.m_123196_(chunkPos1, (int)0), structure1)) {
                    Optional<BlockPos> structureCenter = structureStart.m_73602_().stream().map(structurePiece -> structurePiece.m_73547_().m_162394_()).findAny();
                    if (!structureCenter.isPresent()) continue;
                    int range = structureCenter.get().m_123333_((Vec3i)pos);
                    if (range < distFromStructure) {
                        distFromStructure = range;
                    }
                    if (distFromStructure >= structureRange) continue;
                    return structureCenter.get();
                }
            }
        }
        return null;
    }
}

