/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.StormfishVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistry;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.StormfishVariants;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.LevelData;

public class Stormfish
extends AbstractThievesFish<StormfishVariant> {
    private static final EntityDataAccessor<StormfishVariant> VARIANT = SynchedEntityData.m_135353_(Stormfish.class, FOTDataSerializers.STORMFISH_VARIANT);

    public Stormfish(EntityType<? extends Stormfish> entityType, Level level) {
        super(entityType, level);
    }

    protected Brain.Provider<AbstractThievesFish<?>> m_5490_() {
        return Brain.m_21923_((Collection)MEMORY_TYPES, Stream.of(SENSOR_TYPES, List.of(FOTSensorTypes.LEECHES_THIEVES_FISH_TEMPTATIONS)).flatMap(Collection::stream).toList());
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return AbstractThievesFishAi.makeBrain(this.m_5490_().m_22073_(dynamic));
    }

    public Brain<AbstractThievesFish<?>> m_6274_() {
        return super.m_6274_();
    }

    @Override
    protected void m_8024_() {
        AbstractThievesFishAi.customServerAiStep(this, this.m_6274_());
        super.m_8024_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)StormfishVariants.ANCIENT);
    }

    @Override
    public Registry<StormfishVariant> getRegistry() {
        return FOTRegistry.STORMFISH_VARIANT;
    }

    @Override
    public void setVariant(StormfishVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    @Override
    public StormfishVariant getVariant() {
        return (StormfishVariant)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public Holder<StormfishVariant> getSpawnVariant(boolean creativeBucket) {
        return this.getSpawnVariant((LivingEntity)this, FOTTags.FishVariant.DEFAULT_STORMFISH_SPAWNS, StormfishVariants.ANCIENT, creativeBucket);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)FOTItems.STORMFISH_BUCKET);
    }

    protected SoundEvent m_5592_() {
        return FOTSoundEvents.STORMFISH_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return FOTSoundEvents.STORMFISH_HURT;
    }

    protected SoundEvent m_5699_() {
        return FOTSoundEvents.STORMFISH_FLOP;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.isTrophy() ? super.m_6972_(pose) : EntityDimensions.m_20398_((float)0.4f, (float)0.3f);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return this.isTrophy() ? 0.225f : 0.11f;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightning) {
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return LEECHES_FOOD.test(itemStack);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            BlockPos pos = this.m_20183_();
            if (this.m_9236_().m_46470_() && (long)this.f_19796_.m_188503_(200) <= this.m_9236_().m_46467_() % 200L && pos.m_123342_() == this.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_()) - 1) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.0, 0.0, 0.0);
            }
        }
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean isWater = level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(blockPos.m_7494_()).m_60713_(Blocks.f_49990_);
        LevelData levelData = level.m_6106_();
        return isWater && levelData.m_6533_() && levelData.m_6534_() && level.m_46861_(blockPos);
    }
}

