/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.stevekung.fishofthieves.registry.FOTCriteriaTriggers;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class FollowLivingWithEffect
extends Behavior<PathfinderMob> {
    private final Function<LivingEntity, Float> speedModifier;
    private final Function<LivingEntity, Double> closeEnoughDistance;
    private final Function<LivingEntity, Predicate<LivingEntity>> hasEffectPredicate;

    public FollowLivingWithEffect(Function<LivingEntity, Float> speedModifier, Function<LivingEntity, Predicate<LivingEntity>> hasEffectPredicate) {
        this(speedModifier, livingEntity -> 2.5, hasEffectPredicate);
    }

    public FollowLivingWithEffect(Function<LivingEntity, Float> speedModifier, Function<LivingEntity, Double> closeEnoughDistance, Function<LivingEntity, Predicate<LivingEntity>> hasEffectPredicate) {
        super(Map.of(MemoryModuleType.f_26371_, MemoryStatus.REGISTERED, MemoryModuleType.f_26370_, MemoryStatus.REGISTERED, FOTMemoryModuleTypes.FOLLOW_WITH_EFFECT_COOLDOWN_TICKS, MemoryStatus.VALUE_ABSENT, FOTMemoryModuleTypes.IS_EFFECT_FOLLOWER, MemoryStatus.REGISTERED, MemoryModuleType.f_148205_, MemoryStatus.VALUE_PRESENT, MemoryModuleType.f_217768_, MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.closeEnoughDistance = closeEnoughDistance;
        this.hasEffectPredicate = hasEffectPredicate;
    }

    protected float getSpeedModifier(PathfinderMob pathfinder) {
        return this.speedModifier.apply((LivingEntity)pathfinder).floatValue();
    }

    private Optional<NearestVisibleLivingEntities> getLivingEntitiesHasEffect(PathfinderMob pathfinder) {
        return pathfinder.m_6274_().m_21952_(MemoryModuleType.f_148205_);
    }

    protected boolean m_7773_(long gameTime) {
        return false;
    }

    protected boolean canStillUse(ServerLevel level, PathfinderMob entity, long gameTime) {
        return this.getLivingEntitiesHasEffect(entity).isPresent() && !entity.m_6274_().m_21874_(MemoryModuleType.f_217768_);
    }

    protected void start(ServerLevel level, PathfinderMob entity, long gameTime) {
        entity.m_6274_().m_21879_(FOTMemoryModuleTypes.IS_EFFECT_FOLLOWER, (Object)true);
    }

    protected void stop(ServerLevel level, PathfinderMob entity, long gameTime) {
        Brain brain = entity.m_6274_();
        brain.m_21879_(FOTMemoryModuleTypes.FOLLOW_WITH_EFFECT_COOLDOWN_TICKS, (Object)100);
        brain.m_21879_(FOTMemoryModuleTypes.IS_EFFECT_FOLLOWER, (Object)false);
        brain.m_21936_(MemoryModuleType.f_26370_);
        brain.m_21936_(MemoryModuleType.f_26371_);
    }

    protected void tick(ServerLevel level, PathfinderMob owner, long gameTime) {
        Optional optionalPlayer = this.getLivingEntitiesHasEffect(owner).get().m_186116_(this.hasEffectPredicate.apply((LivingEntity)owner));
        if (optionalPlayer.isPresent()) {
            LivingEntity player = (LivingEntity)optionalPlayer.get();
            Brain brain = owner.m_6274_();
            brain.m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)player, true));
            Double distance = this.closeEnoughDistance.apply((LivingEntity)owner);
            if (owner.m_20280_((Entity)player) < Mth.m_144952_((double)distance)) {
                brain.m_21936_(MemoryModuleType.f_26370_);
            } else {
                brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)player, false), this.getSpeedModifier(owner), 2));
            }
            if (gameTime % 80L == 0L && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                FOTCriteriaTriggers.FOLLOW_LIVING_WITH_EFFECT.trigger(serverPlayer, (Entity)owner);
            }
        }
    }
}

