/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Bucketable;

public class FishBreaching<E extends LivingEntity>
extends Behavior<E> {
    private static final int[] STEPS_TO_CHECK = new int[]{1, 2, 3};
    private final float jumpVelocity;
    private final float horizontalVelocity;
    private final UniformInt chance;

    public FishBreaching(UniformInt chance, float jumpVelocity, float horizontalVelocity) {
        super(Map.of(MemoryModuleType.f_26370_, MemoryStatus.REGISTERED, MemoryModuleType.f_148199_, MemoryStatus.VALUE_ABSENT, FOTMemoryModuleTypes.BREACHED_TICK, MemoryStatus.REGISTERED));
        this.jumpVelocity = jumpVelocity;
        this.horizontalVelocity = horizontalVelocity;
        this.chance = chance;
    }

    protected boolean m_6114_(ServerLevel level, E owner) {
        Bucketable bucketable;
        if (owner instanceof Bucketable && (bucketable = (Bucketable)owner).m_27487_()) {
            return false;
        }
        Direction direction = owner.m_6374_();
        int stepX = direction.m_122429_();
        int stepZ = direction.m_122431_();
        BlockPos blockPos = owner.m_20183_();
        for (int scale : STEPS_TO_CHECK) {
            if (this.waterIsClear(owner, blockPos, stepX, stepZ, scale) && this.surfaceIsClear(owner, blockPos, stepX, stepZ, scale)) continue;
            return false;
        }
        return true;
    }

    protected void m_6735_(ServerLevel level, E entity, long gameTime) {
        Direction direction = entity.m_6374_();
        entity.m_216990_(FOTSoundEvents.FISH_JUMP);
        entity.m_20256_(entity.m_20184_().m_82520_((double)((float)direction.m_122429_() * this.horizontalVelocity), (double)this.jumpVelocity, (double)((float)direction.m_122431_() * this.horizontalVelocity)));
        entity.m_6274_().m_21879_(FOTMemoryModuleTypes.BREACHED_TICK, (Object)20);
    }

    protected void m_6732_(ServerLevel level, E entity, long gameTime) {
        entity.m_6274_().m_21879_(MemoryModuleType.f_148199_, (Object)this.chance.m_214085_(level.f_46441_));
        entity.m_146926_(0.0f);
    }

    private boolean waterIsClear(E entity, BlockPos blockPos, int dx, int dz, int scale) {
        blockPos = blockPos.m_7918_(dx * scale, 0, dz * scale);
        return entity.m_9236_().m_6425_(blockPos).m_205070_(FluidTags.f_13131_) && !entity.m_9236_().m_8055_(blockPos).m_280555_();
    }

    private boolean surfaceIsClear(E entity, BlockPos blockPos, int dx, int dz, int scale) {
        return entity.m_9236_().m_8055_(blockPos.m_7918_(dx * scale, 1, dz * scale)).m_60795_() && entity.m_9236_().m_8055_(blockPos.m_7918_(dx * scale, 2, dz * scale)).m_60795_();
    }
}

