/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai.behavior;

import com.mojang.datafixers.DataFixUtils;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class CreateFishFlock
extends Behavior<AbstractSchoolingThievesFish> {
    private static final Predicate<AbstractSchoolingThievesFish> CAN_BE_FOLLOWED = AbstractSchoolingThievesFish::m_27542_;
    private static final Predicate<AbstractSchoolingThievesFish> NOT_LEADER = Predicate.not(AbstractSchoolingThievesFish::isLeader);
    private static final Predicate<AbstractSchoolingThievesFish> NOT_FOLLOWER = Predicate.not(AbstractSchoolingThievesFish::m_27540_);
    private static final Predicate<AbstractSchoolingThievesFish> TROPHY = AbstractSchoolingThievesFish::isTrophy;
    private static final Predicate<AbstractSchoolingThievesFish> HAS_NO_FOLLOW_COOLDOWN = Predicate.not(AbstractSchoolingThievesFish::hasFollowCooldown);

    public CreateFishFlock() {
        super(Map.of(FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH, MemoryStatus.VALUE_PRESENT, FOTMemoryModuleTypes.SCHOOL_SIZE, MemoryStatus.VALUE_PRESENT, FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, MemoryStatus.VALUE_ABSENT));
    }

    protected void start(ServerLevel level, AbstractSchoolingThievesFish entity, long gameTime) {
        Optional optional = entity.m_6274_().m_21952_(FOTMemoryModuleTypes.NEAREST_VISIBLE_SCHOOLING_THIEVES_FISH);
        if (!entity.m_27540_() && !entity.isLeader() && optional.isPresent()) {
            Predicate<AbstractSchoolingThievesFish> lineOfSight = arg_0 -> ((AbstractSchoolingThievesFish)entity).m_142582_(arg_0);
            Optional<AbstractSchoolingThievesFish> nearestFish = ((List)optional.get()).stream().filter(lineOfSight.and(CAN_BE_FOLLOWED).and(NOT_FOLLOWER)).findAny();
            AbstractSchoolingThievesFish leader = (AbstractSchoolingThievesFish)DataFixUtils.orElse(nearestFish, (Object)entity);
            if (leader.isTrophy()) {
                leader.addThievesFishFollowers(((List)optional.get()).stream().filter(leader::isSameType).filter(lineOfSight.and(NOT_FOLLOWER).and(NOT_LEADER).and(HAS_NO_FOLLOW_COOLDOWN).and(TROPHY.negate().or(TROPHY))));
            } else {
                Supplier<Stream> supplier = () -> ((List)optional.get()).stream().filter(lineOfSight.and(NOT_FOLLOWER).and(NOT_LEADER));
                supplier.get().filter(TROPHY).findAny().ifPresentOrElse(fish -> fish.addThievesFishFollowers(((Stream)supplier.get()).filter(HAS_NO_FOLLOW_COOLDOWN.and(fish::isSameType))), () -> leader.addThievesFishFollowers(((Stream)supplier.get()).filter(HAS_NO_FOLLOW_COOLDOWN.and(leader::isSameType))));
            }
        }
    }

    public static int nextStartTick(RandomSource randomSource) {
        return CreateFishFlock.nextStartTick(randomSource, 200);
    }

    public static int nextStartTick(RandomSource randomSource, int nextTicks) {
        return Mth.m_184652_((int)(nextTicks + randomSource.m_188503_(nextTicks) % 20), (int)2);
    }
}

