/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.FishData;
import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.spawn.SpawnSelectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.jetbrains.annotations.Nullable;

public interface ThievesFish<T extends FishData>
extends PartyFish {
    public static final Ingredient WORMS = Ingredient.m_204132_(FOTTags.Items.WORMS);
    public static final Ingredient EARTHWORMS_FOOD = Ingredient.m_204132_(FOTTags.Items.EARTHWORMS_FOOD);
    public static final Ingredient GRUBS_FOOD = Ingredient.m_204132_(FOTTags.Items.GRUBS_FOOD);
    public static final Ingredient LEECHES_FOOD = Ingredient.m_204132_(FOTTags.Items.LEECHES_FOOD);
    public static final String VARIANT_TAG = "variant";
    public static final String CREATIVE_TAG = "creative";
    public static final String TROPHY_TAG = "Trophy";
    public static final String HAS_FED_TAG = "HasFed";
    public static final String NO_FLIP_TAG = "NoFlip";

    public T getVariant();

    public void setVariant(T var1);

    public Holder<T> getSpawnVariant(boolean var1);

    public Registry<T> getRegistry();

    public boolean isTrophy();

    public void setTrophy(boolean var1);

    public boolean hasFed();

    public void setHasFed(boolean var1);

    public boolean isFood(ItemStack var1);

    public void setNoFlip(boolean var1);

    public boolean isNoFlip();

    default public float getGlowBrightness(float ageInTicks) {
        return 1.0f;
    }

    default public boolean isFishBreached(Brain<?> brain) {
        return brain.m_21874_(FOTMemoryModuleTypes.BREACHED_TICK) && (Integer)brain.m_21952_(FOTMemoryModuleTypes.BREACHED_TICK).get() > 0;
    }

    default public boolean isTreasured() {
        return this.getVariant().isTreasured().isPresent();
    }

    default public void saveToBucket(CompoundTag compound) {
        ResourceLocation variant = this.getRegistry().m_7981_(this.getVariant());
        if (variant != null) {
            compound.m_128359_(this.getVariantKey(), variant.toString());
        }
        if (this.isTrophy()) {
            compound.m_128379_(HAS_FED_TAG, this.hasFed());
            compound.m_128379_(TROPHY_TAG, this.isTrophy());
        }
        if (this.isNoFlip()) {
            compound.m_128379_(NO_FLIP_TAG, this.isNoFlip());
        }
    }

    default public void loadFromBucket(CompoundTag compound) {
        FishData variant;
        if (compound.m_128441_(this.getVariantKey()) && (variant = (FishData)this.getRegistry().m_7745_(ResourceLocation.m_135820_((String)this.getVariantKey()))) != null) {
            this.setVariant(variant);
        }
        if (compound.m_128441_(TROPHY_TAG)) {
            this.setTrophy(compound.m_128471_(TROPHY_TAG));
        }
        if (compound.m_128441_(HAS_FED_TAG)) {
            this.setHasFed(compound.m_128471_(HAS_FED_TAG));
        }
        if (compound.m_128441_(NO_FLIP_TAG)) {
            this.setNoFlip(compound.m_128471_(NO_FLIP_TAG));
        }
    }

    default public SpawnGroupData defaultFinalizeSpawn(LivingEntity livingEntity, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        boolean fromCreative;
        boolean bl = fromCreative = dataTag != null && dataTag.m_128441_(CREATIVE_TAG);
        if (reason == MobSpawnType.BUCKET && dataTag != null && dataTag.m_128441_(this.getVariantKey()) && !dataTag.m_128441_(CREATIVE_TAG)) {
            FishData variant = (FishData)this.getRegistry().m_7745_(ResourceLocation.m_135820_((String)dataTag.m_128461_(this.getVariantKey())));
            if (variant != null) {
                this.setVariant(variant);
            }
            this.setTrophy(dataTag.m_128471_(TROPHY_TAG));
            return spawnData;
        }
        if (livingEntity.m_217043_().m_188501_() < FishOfThieves.CONFIG.spawnRate.trophyProbability) {
            this.setTrophy(true);
            livingEntity.m_21153_(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.setVariant((FishData)this.getSpawnVariant(reason == MobSpawnType.BUCKET && fromCreative).m_203334_());
        return spawnData;
    }

    default public Holder<T> getSpawnVariant(LivingEntity livingEntity, TagKey<T> tagKey, T defaultSpawn, boolean creativeBucket) {
        return this.getRegistry().m_203431_(tagKey).flatMap(named -> named.m_213653_(livingEntity.m_217043_())).filter(variant -> creativeBucket || ((FishData)variant.m_203334_()).getCondition().test(SpawnSelectors.get((ServerLevel)livingEntity.m_9236_(), livingEntity.m_20183_(), livingEntity.m_217043_()))).orElseGet(() -> Holder.m_205709_((Object)defaultSpawn));
    }

    private String getVariantKey() {
        return this.getRegistry().m_123023_().m_135782_().m_135815_();
    }

    default public float calculateTreasuredGlow(Level level, BlockPos blockPos) {
        long dayTime = level.m_46468_() % 24000L;
        int skyLight = level.m_45517_(LightLayer.SKY, blockPos);
        float glowIntensityWithSkylight = (float)(15 - skyLight) / 15.0f;
        int glowingNightTimeStart = 12500;
        int glowingNightTimeEnd = 13500;
        int glowingMorningTimeStart = 22700;
        if (dayTime >= (long)glowingNightTimeStart && dayTime < (long)glowingNightTimeEnd) {
            glowIntensityWithSkylight = Math.min(0.5f, Math.max((float)(dayTime - (long)glowingNightTimeStart) / 1000.0f, glowIntensityWithSkylight) + 0.05f);
        } else if (dayTime >= (long)glowingNightTimeEnd && dayTime < (long)glowingMorningTimeStart) {
            glowIntensityWithSkylight = 0.5f;
        } else if (dayTime >= (long)glowingMorningTimeStart) {
            glowIntensityWithSkylight = Math.max(glowIntensityWithSkylight, 0.5f - (float)(dayTime - (long)glowingMorningTimeStart) / 1000.0f + 0.05f);
        }
        return Math.min(glowIntensityWithSkylight, (float)(15 - level.m_45517_(LightLayer.BLOCK, blockPos)) / 15.0f);
    }
}

