/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.stevekung.fishofthieves.entity.shoal.Shoal;
import com.stevekung.fishofthieves.mixin.client.accessor.EntityRenderDispatcherAccessor;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;

public class ShoalRenderer
extends EntityRenderer<Shoal> {
    private final EntityRenderDispatcher entityRenderDispatcher;

    public ShoalRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.entityRenderDispatcher = context.m_174022_();
    }

    public void render(Shoal shoal, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        float ageInTicks = (float)shoal.f_19797_ + partialTicks;
        List<LivingEntity> list = shoal.getShoalFishClient();
        float offsetPerFish = 360.0f / (float)list.size();
        float modifier = 15.0f;
        float rotationModifier = 0.25f;
        float radiusBase = 1.0f;
        float radiusMod = 0.1f;
        float v = 0.125f;
        poseStack.m_252880_(-0.05f, 0.0f, 0.0f);
        for (int index = 0; index < list.size(); ++index) {
            LivingEntity entity = list.get(index);
            float offset = offsetPerFish * (float)index;
            float deg = (int)(ageInTicks / rotationModifier % 360.0f + offset);
            float rad = (float)((double)(deg / 180.0f) * Math.PI);
            float radiusX = (float)((double)radiusBase + (double)radiusMod * Math.sin(ageInTicks / modifier));
            float radiusZ = (float)((double)radiusBase + (double)radiusMod * Math.cos(ageInTicks / modifier));
            float x = (float)((double)radiusX * Math.cos(rad));
            float z = (float)((double)radiusZ * Math.sin(rad));
            float y = (float)Math.cos((ageInTicks + (float)(50 * index)) / 5.0f) / 10.0f;
            poseStack.m_85836_();
            poseStack.m_252880_(x, y, z);
            float yRotate = Math.max(0.6f, Mth.m_14031_((float)(ageInTicks * 0.1f)) / 4.0f);
            float zRotate = (float)Math.cos(0.1f * ageInTicks) / 16.0f;
            poseStack.m_252880_(v /= 2.0f, v, v);
            poseStack.m_252781_(new Quaternionf().rotateAxis(-rad, 0.0f, yRotate, zRotate));
            poseStack.m_252880_(-v, -v, -v);
            v *= 2.0f;
            this.renderEntityInShoal((Entity)entity, ageInTicks, entityYaw, partialTicks, poseStack, buffer, packedLight);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)shoal, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderEntityInShoal(Entity entity, float ageInTicks, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        EntityRenderer<?> renderer = ((EntityRenderDispatcherAccessor)this.entityRenderDispatcher).getRenderers().get(entity.m_6095_());
        renderer.m_7392_(entity, entityYaw, ageInTicks, poseStack, buffer, packedLight);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
                float yBodyRot = Mth.m_14189_((float)partialTicks, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
                float yHeadRot = Mth.m_14189_((float)partialTicks, (float)livingEntity.f_20886_, (float)livingEntity.f_20885_);
                float netHeadYaw = yHeadRot - yBodyRot;
                float limbSwingAmount = 0.0f;
                float limbSwing = 0.0f;
                float headPitch = Mth.m_14179_((float)partialTicks, (float)livingEntity.f_19860_, (float)livingEntity.m_146909_());
                if (LivingEntityRenderer.m_194453_((LivingEntity)livingEntity)) {
                    headPitch *= -1.0f;
                    netHeadYaw *= -1.0f;
                }
                if (!livingEntity.m_20159_() && livingEntity.m_6084_()) {
                    limbSwingAmount = livingEntity.f_267362_.m_267711_(partialTicks);
                    limbSwing = livingEntity.f_267362_.m_267590_(partialTicks);
                    if (livingEntity.m_6162_()) {
                        limbSwing *= 3.0f;
                    }
                    if (limbSwingAmount > 1.0f) {
                        limbSwingAmount = 1.0f;
                    }
                }
                EntityModel model = livingEntityRenderer.m_7200_();
                model.m_6839_((Entity)livingEntity, limbSwing, limbSwingAmount, partialTicks);
                model.m_6973_((Entity)livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }

    public ResourceLocation getTextureLocation(Shoal entity) {
        return null;
    }
}

