/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer.debug;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.FishOfThieves;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;

public class StructureCenterPosDebugRenderer
implements DebugRenderer.SimpleDebugRenderer {
    private final Minecraft minecraft;
    private final List<Pair<BlockPos, ResourceLocation>> structurePosList = new ArrayList<Pair<BlockPos, ResourceLocation>>();

    public StructureCenterPosDebugRenderer(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void m_7790_(PoseStack poseStack, MultiBufferSource buffer, double camX, double camY, double camZ) {
        Optional<Pair> optional;
        int distFromStructure = Integer.MAX_VALUE;
        BlockPos entityPos = this.minecraft.f_91074_.m_20183_();
        List posList = this.structurePosList.stream().distinct().toList();
        posList.forEach(pair -> {
            BlockPos blockPos = (BlockPos)pair.getFirst();
            if (blockPos.m_123333_((Vec3i)entityPos) < 512) {
                AABB aabb = new AABB((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (double)((float)blockPos.m_123341_() + 1.0f), (double)((float)blockPos.m_123342_() + 1.0f), (double)((float)blockPos.m_123343_() + 1.0f));
                DebugRenderer.m_269311_((PoseStack)poseStack, (MultiBufferSource)buffer, (AABB)aabb.m_82386_(-camX, -camY, -camZ), (float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
            }
        });
        if (FishOfThieves.CONFIG.debug.displayStructureCenterPosInfo && (optional = posList.stream().filter(pair -> ((BlockPos)pair.getFirst()).m_123333_((Vec3i)entityPos) <= FishOfThieves.CONFIG.debug.structureCenterPosRangeLimit).min(Comparator.comparing(pair -> ((BlockPos)pair.getFirst()).m_123333_((Vec3i)entityPos)))).isPresent()) {
            BlockPos blockPos = (BlockPos)optional.get().getFirst();
            int structureDist = blockPos.m_123333_((Vec3i)entityPos);
            if (structureDist < distFromStructure) {
                distFromStructure = structureDist;
            }
            this.minecraft.f_91065_.m_93063_((Component)Component.m_237113_((String)(String.valueOf(optional.get().getSecond()) + ": " + distFromStructure + ", pos: " + blockPos.m_123344_())), false);
        }
    }

    public void m_5630_() {
        this.structurePosList.clear();
    }

    public void addStructure(List<Pair<BlockPos, ResourceLocation>> structurePosList) {
        this.structurePosList.addAll(structurePosList);
    }
}

