/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.blockentity;

import com.stevekung.fishofthieves.block.FishPlaqueBlock;
import com.stevekung.fishofthieves.registry.FOTBlockEntityTypes;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FishPlaqueBlockEntity
extends BlockEntity {
    public static final String PLAQUE_DATA_TAG = "PlaqueData";
    public static final String WAXED_TAG = "Waxed";
    private boolean waxed;
    private int animationTickCount;
    private boolean isAnimating;
    @Nullable
    private Entity displayEntity;
    @Nullable
    private CompoundTag plaqueData;

    public FishPlaqueBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(FOTBlockEntityTypes.FISH_PLAQUE, blockPos, blockState);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_(PLAQUE_DATA_TAG, 10)) {
            this.setPlaqueData(tag.m_128469_(PLAQUE_DATA_TAG));
        }
        this.waxed = tag.m_128471_(WAXED_TAG);
        this.displayEntity = null;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.plaqueData != null) {
            tag.m_128365_(PLAQUE_DATA_TAG, (Tag)this.plaqueData);
        }
        tag.m_128379_(WAXED_TAG, this.waxed);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        this.displayEntity = null;
        return this.m_187482_();
    }

    public boolean m_6326_() {
        return true;
    }

    public void setPlaqueData(CompoundTag plaqueData) {
        this.plaqueData = plaqueData;
    }

    @Nullable
    public CompoundTag getPlaqueData() {
        return this.plaqueData;
    }

    public boolean hasPlaqueData() {
        return this.plaqueData != null && this.plaqueData.m_128425_("id", 8);
    }

    public void setWaxed(boolean waxed) {
        this.waxed = waxed;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public String getEntityKeyFromPlaqueData() {
        return this.plaqueData.m_128461_("id");
    }

    public void clearDisplayEntity() {
        this.plaqueData = null;
        this.displayEntity = null;
    }

    public static void animation(Level level, BlockPos pos, BlockState state, FishPlaqueBlockEntity blockEntity) {
        if (state.m_61138_((Property)FishPlaqueBlock.POWERED) && ((Boolean)state.m_61143_((Property)FishPlaqueBlock.POWERED)).booleanValue()) {
            blockEntity.isAnimating = true;
            ++blockEntity.animationTickCount;
        } else {
            blockEntity.isAnimating = false;
        }
    }

    public float getAnimation(float partialTick) {
        return this.isAnimating ? (float)this.animationTickCount + partialTick : (float)this.animationTickCount;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level level) {
        if (!this.hasPlaqueData()) {
            return null;
        }
        if (this.displayEntity == null) {
            this.displayEntity = FishPlaqueBlockEntity.createEntity(this, level);
        }
        return this.displayEntity;
    }

    @Nullable
    public static Entity createEntity(FishPlaqueBlockEntity blockEntity, Level level) {
        return EntityType.m_20645_((CompoundTag)blockEntity.getPlaqueData(), (Level)level, Function.identity());
    }
}

