/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.AbstractBananaClusterBlock;
import com.stevekung.fishofthieves.block.BananaClusterBlock;
import com.stevekung.fishofthieves.block.BananaClusterPlantBlock;
import com.stevekung.fishofthieves.block.BananaHangingType;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UnderripeBananaClusterPlantBlock
extends AbstractBananaClusterBlock
implements BonemealableBlock {
    private static final Map<Direction, VoxelShape> UNDERRIPE_SHAPES = Map.of(Direction.NORTH, Block.m_49796_((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)16.0, (double)10.0), Direction.WEST, Block.m_49796_((double)2.0, (double)4.0, (double)4.0, (double)10.0, (double)16.0, (double)12.0), Direction.SOUTH, Block.m_49796_((double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)16.0, (double)14.0), Direction.EAST, Block.m_49796_((double)6.0, (double)4.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0));
    public static final EnumProperty<BananaHangingType> HANGING = EnumProperty.m_61587_((String)"hanging", BananaHangingType.class);

    public UnderripeBananaClusterPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HANGING, (Comparable)((Object)BananaHangingType.CLUSTER))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (BananaClusterBlock.canClusterPlantGrow((Level)level, pos) && random.m_188503_(15) == 0) {
            this.growBananaCluster(level, random, pos, state);
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.m_188503_(8) == 0;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growBananaCluster(level, random, pos, state);
    }

    private void growBananaCluster(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        FluidState fluidState = level.m_6425_(pos);
        BlockState otherCluster = level.m_8055_(pos.m_7494_());
        if (random.m_188501_() < 0.4f) {
            level.m_7731_(pos, (BlockState)((BlockState)((BlockState)FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.m_49966_().m_61124_(BananaClusterPlantBlock.HANGING, (Comparable)((Object)(state.m_61143_(HANGING) == BananaHangingType.STEM ? BananaClusterPlantBlock.HangingType.STEM : (otherCluster.m_60713_((Block)this) ? BananaClusterPlantBlock.HangingType.SMALL_CLUSTER : BananaClusterPlantBlock.HangingType.NONE))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_))), 3);
        } else {
            level.m_7731_(pos, (BlockState)((BlockState)((BlockState)FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT.m_49966_().m_61124_(BananaClusterPlantBlock.HANGING, (Comparable)((Object)(state.m_61143_(HANGING) == BananaHangingType.STEM ? BananaClusterPlantBlock.HangingType.STEM : (otherCluster.m_60713_((Block)this) ? BananaClusterPlantBlock.HangingType.SMALL_CLUSTER : BananaClusterPlantBlock.HangingType.NONE))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_))), 3);
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)FOTBlocks.UNDERRIPE_BANANA_CLUSTER);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.UP && (neighborState.m_60713_(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT) || neighborState.m_60713_(FOTBlocks.RIPE_BANANA_CLUSTER_PLANT))) {
            return (BlockState)state.m_61124_(HANGING, (Comparable)((Object)BananaHangingType.CLUSTER));
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public boolean m_6104_(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.m_204336_(FOTTags.Blocks.BANANA_CLUSTER_PLANTS) && !adjacentState.m_60713_((Block)this) && direction.m_122434_().m_122478_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return UNDERRIPE_SHAPES.get(state.m_61143_((Property)f_54117_));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HANGING, WATERLOGGED});
    }
}

