/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShoalBlock
extends Block
implements BucketPickup {
    public static final BooleanProperty TREASURED = BooleanProperty.m_61465_((String)"treasured");

    public ShoalBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)TREASURED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        level.m_7107_((ParticleOptions)ParticleTypes.f_123795_, x + 0.5, y, z + 0.5, 0.0, 0.04, 0.0);
        level.m_7107_((ParticleOptions)ParticleTypes.f_123795_, x + (double)random.m_188501_(), y + (double)random.m_188501_(), z + (double)random.m_188501_(), 0.0, 0.04, 0.0);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213897_(state, level, pos, random);
        this.destroyShoal(state, (Level)level, pos);
    }

    public FluidState m_5888_(BlockState state) {
        return Fluids.f_76193_.m_76068_(false);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_186460_(pos, (Block)this, 5);
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!state.m_60710_((LevelReader)level, pos) || movedByPiston) {
            this.destroyShoal(state, level, pos);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return ShoalBlock.canSurvive(level, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TREASURED});
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 11);
        return new ItemStack((ItemLike)Items.f_42447_);
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public static boolean canSurvive(LevelReader level, BlockPos pos) {
        return BlockPos.m_121990_((BlockPos)pos.m_7918_(-1, 0, -1), (BlockPos)pos.m_7918_(1, -2, 1)).allMatch(blockPos -> {
            BlockState blockState = level.m_8055_(blockPos);
            FluidState fluidState = blockState.m_60819_();
            return fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_() && blockState.m_60812_((BlockGetter)level, blockPos).m_83281_();
        });
    }

    private void destroyShoal(BlockState state, Level level, BlockPos pos) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 2);
        }
    }
}

