/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.PosAndState;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTItems;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PineappleCropBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)5);
    private static final VoxelShape BASE_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    private static final VoxelShape STAGE_3_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.5, (double)9.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), (VoxelShape)BASE_SHAPE, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape STAGE_4_COLLISION_SHAPE = Block.m_49796_((double)5.0, (double)-7.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    private static final VoxelShape STAGE_4_LOWER_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), (VoxelShape)BASE_SHAPE, (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape STAGE_4_SHAPE = Shapes.m_83113_((VoxelShape)STAGE_4_COLLISION_SHAPE, (VoxelShape)Block.m_49796_((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape STAGE_5_COLLISION_SHAPE = Shapes.m_83113_((VoxelShape)Block.m_49796_((double)6.0, (double)-7.0, (double)6.0, (double)10.0, (double)-6.0, (double)10.0), (VoxelShape)Block.m_49796_((double)4.0, (double)-6.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape STAGE_5_LOWER_SHAPE = Stream.of(Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0), BASE_SHAPE).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape STAGE_5_SHAPE = Stream.of(STAGE_5_COLLISION_SHAPE, Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public PineappleCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.LOWER));
    }

    private int getMaxAge() {
        return 5;
    }

    private boolean isLowerAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < this.getMaxAge();
    }

    public boolean m_6724_(BlockState state) {
        return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER && this.isLowerAge(state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            if (age == 4) {
                return STAGE_4_COLLISION_SHAPE;
            }
            if (age == 5) {
                return STAGE_5_COLLISION_SHAPE;
            }
        }
        return super.m_5939_(state, level, pos, context);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (!PineappleCropBlock.isLower(state) && (Integer)state.m_61143_((Property)AGE) >= 4) {
            float destroySpeed = 0.6f;
            int i = player.m_36298_(state) ? 30 : 100;
            return player.m_36281_(state) / destroySpeed / (float)i;
        }
        return super.m_5880_(state, player, level, pos);
    }

    public SoundType m_49962_(BlockState state) {
        Integer age;
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER && (age = (Integer)state.m_61143_((Property)AGE)) >= 4) {
            return SoundType.f_56736_;
        }
        return super.m_49962_(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (!PineappleCropBlock.sufficientLight(level, pos)) {
            return false;
        }
        return super.m_7898_(state, level, pos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.m_60713_(Blocks.f_50093_) || state.m_204336_(BlockTags.f_144274_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AGE}));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        Integer age = (Integer)state.m_61143_((Property)AGE);
        if (!level.m_5776_() && age >= 4 && EnchantmentHelper.m_272262_((ItemStack)player.m_21205_())) {
            PineappleCropBlock.m_52903_((Level)level, (BlockPos)pos, (BlockState)state, (Player)player);
        }
        super.m_5707_(level, pos, state, player);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age == 3) {
            return STAGE_3_SHAPE;
        }
        if (age == 4) {
            return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? STAGE_4_SHAPE : STAGE_4_LOWER_SHAPE;
        }
        if (age == 5) {
            return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? STAGE_5_SHAPE : STAGE_5_LOWER_SHAPE;
        }
        return BASE_SHAPE;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && level.m_46469_().m_46207_(GameRules.f_46132_)) {
            level.m_46953_(pos, true, entity);
        }
        super.m_7892_(state, level, pos, entity);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed = CropBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos);
        if (random.m_188503_((int)(25.0f / growthSpeed) + 1) == 0) {
            this.grow(level, state, pos, 1);
        }
    }

    private void grow(ServerLevel level, BlockState state, BlockPos pos, int growthAge) {
        int age = Math.min((Integer)state.m_61143_((Property)AGE) + growthAge, this.getMaxAge());
        if (this.canGrow((LevelReader)level, pos, state, age)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
            if (age >= 4) {
                BlockPos blockPos = pos.m_7494_();
                level.m_7731_(blockPos, PineappleCropBlock.m_182453_((LevelReader)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(age))).m_61124_((Property)f_52858_, (Comparable)DoubleBlockHalf.UPPER))), 3);
            }
        }
    }

    private static boolean canGrowInto(LevelReader level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_60795_() || blockState.m_60713_(FOTBlocks.PINEAPPLE_CROP);
    }

    private static boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos);
    }

    private static boolean isLower(BlockState state) {
        return state.m_60713_(FOTBlocks.PINEAPPLE_CROP) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER;
    }

    private boolean canGrow(LevelReader reader, BlockPos pos, BlockState state, int age) {
        return this.isLowerAge(state) && PineappleCropBlock.sufficientLight(reader, pos) && (age < 4 || PineappleCropBlock.canGrowInto(reader, pos.m_7494_()));
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader level, BlockPos pos, BlockState state) {
        if (PineappleCropBlock.isLower(state)) {
            return new PosAndState(pos, state);
        }
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = level.m_8055_(blockPos);
        return PineappleCropBlock.isLower(blockState) ? new PosAndState(blockPos, blockState) : null;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        PosAndState posAndState = this.getLowerHalf(level, pos, state);
        return posAndState != null && this.canGrow(level, posAndState.pos(), posAndState.state(), (Integer)posAndState.state().m_61143_((Property)AGE) + 1);
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        PosAndState posAndState = this.getLowerHalf((LevelReader)level, pos, state);
        if (posAndState != null) {
            this.grow(level, posAndState.state(), posAndState.pos(), Mth.m_216271_((RandomSource)random, (int)1, (int)2));
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER) {
            return (Integer)state.m_61143_((Property)AGE) == 5 ? new ItemStack((ItemLike)FOTBlocks.RIPE_PINEAPPLE_BLOCK) : ((Integer)state.m_61143_((Property)AGE) == 4 ? new ItemStack((ItemLike)FOTBlocks.UNDERRIPE_PINEAPPLE_BLOCK) : new ItemStack((ItemLike)FOTItems.PINEAPPLE_CROWN));
        }
        return (Integer)state.m_61143_((Property)AGE) == 0 ? new ItemStack((ItemLike)FOTItems.PINEAPPLE_SEEDS) : new ItemStack((ItemLike)FOTItems.PINEAPPLE_CROWN);
    }
}

