/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.VerticalLeavesBlock;
import com.stevekung.fishofthieves.client.AngledLeavesComponent;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.utils.CauldronUtils;
import com.stevekung.fishofthieves.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CoconutFrondsBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape NOT_MIDDLE = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public CoconutFrondsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(PART, (Comparable)((Object)Part.SINGLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_46758_(pos.m_7494_()) && state.m_61143_(PART) == Part.TAIL && random.m_188501_() < 0.7f) {
            CauldronUtils.fillCauldronFromLeavesTail(state, level, pos);
        }
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        if (context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).m_193113_() != null && entityCollisionContext.m_193113_().m_6069_()) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, level, pos, context);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        BlockState otherState = level.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)));
        return otherState.m_247087_();
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        FluidState fluidState = level.m_6425_(pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)));
        level.m_7731_(pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)), (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)Part.TAIL))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_)), 3);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockPos oppositePos = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
        BlockState oppositeState = level.m_8055_(oppositePos);
        BlockState facingState = level.m_8055_(pos.m_121945_((Direction)state.m_61143_((Property)f_54117_)));
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        switch (((Part)((Object)state.m_61143_(PART))).ordinal()) {
            case 0: {
                if (!facingState.m_60713_((Block)this) || facingState.m_61143_((Property)f_54117_) != state.m_61143_((Property)f_54117_)) break;
                return (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.STEM));
            }
            case 1: {
                if (facingState.m_60713_((Block)this)) break;
                return (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.SINGLE));
            }
            case 2: {
                if (!facingState.m_60713_((Block)this)) {
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.TAIL));
                }
                if (oppositeState.m_60713_((Block)this) || !oppositeState.m_280296_()) break;
                return (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.STEM));
            }
            case 3: {
                if (facingState.m_60713_((Block)this) && facingState.m_61143_((Property)f_54117_) == state.m_61143_((Property)f_54117_) && facingState.m_61143_(PART) == Part.TAIL) {
                    return (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.MIDDLE));
                }
                if (oppositeState.m_60713_(Blocks.f_50016_)) {
                    return Blocks.f_50016_.m_49966_();
                }
                if (oppositeState.m_60713_((Block)this) || !oppositeState.m_280296_()) break;
                return (BlockState)state.m_61124_(PART, (Comparable)((Object)Part.SINGLE));
            }
        }
        return state.m_60710_((LevelReader)level, pos) ? super.m_7417_(state, direction, neighborState, level, pos, neighborPos) : Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_7947_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState otherState = level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_()));
        if (otherState.m_60713_((Block)this)) {
            return state.m_61143_((Property)f_54117_) == otherState.m_61143_((Property)f_54117_);
        }
        return otherState.m_204336_(FOTTags.Blocks.COCONUT_LOGS) || otherState.m_204336_(FOTTags.Blocks.SMALL_COCONUT_LOGS) || otherState.m_204336_(BlockTags.f_13035_) && otherState.m_60838_((BlockGetter)level, pos) || otherState.m_60783_((BlockGetter)level, pos, (Direction)state.m_61143_((Property)f_54117_));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.m_46758_(pos.m_7494_()) && random.m_188503_(8) == 0) {
            Direction direction = (Direction)state.m_61143_((Property)f_54117_);
            switch (((Part)((Object)state.m_61143_(PART))).ordinal()) {
                case 2: {
                    BlockPos blockPos = pos.m_7495_();
                    BlockState blockState = level.m_8055_(blockPos);
                    if (blockState.m_60815_() && blockState.m_60783_((BlockGetter)level, blockPos, Direction.UP)) break;
                    double x = (double)pos.m_123341_() + random.m_188500_();
                    double y = (double)pos.m_123342_() + 0.75;
                    double z = (double)pos.m_123343_() + random.m_188500_();
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123803_, x, y, z, 0.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    AngledLeavesComponent component = new AngledLeavesComponent(-22.5, 1.0, 0.0);
                    ParticleUtils.spawnDrippingWaterParticlesForLeaves(level, direction, pos, random, UniformInt.m_146622_((int)2, (int)6), 0.3, 2, true, true, component);
                    break;
                }
                case 0: {
                    AngledLeavesComponent component = new AngledLeavesComponent(-22.5, 1.0, 30.0);
                    ParticleUtils.spawnDrippingWaterParticlesForLeaves(level, direction, pos, random, UniformInt.m_146622_((int)2, (int)6), -0.1, 2, false, true, component);
                    break;
                }
                case 3: {
                    AngledLeavesComponent component = new AngledLeavesComponent(22.5, 0.9, 35.0);
                    ParticleUtils.spawnDrippingWaterParticlesForLeaves(level, direction, pos, random, UniformInt.m_146622_((int)2, (int)8), 0.25, 4, false, true, component);
                }
            }
        }
    }

    private BlockState placeVerticalLeaves(Direction direction, boolean isWater) {
        BlockState blockState = (BlockState)FOTBlocks.VERTICAL_COCONUT_FRONDS.m_49966_().m_61124_((Property)VerticalLeavesBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
        return direction == Direction.DOWN ? (BlockState)blockState.m_61124_((Property)VerticalLeavesBlock.CEILING, (Comparable)Boolean.valueOf(true)) : blockState;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean isWater;
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        Direction direction = context.m_43719_();
        boolean bl = isWater = fluidState.m_76152_() == Fluids.f_76193_;
        if (direction.m_122434_() == Direction.Axis.Y) {
            return this.placeVerticalLeaves(direction, isWater);
        }
        BlockState blockState = (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction);
        BlockState otherState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(((Direction)blockState.m_61143_((Property)f_54117_)).m_122424_()));
        if (otherState.m_60713_((Block)this) && (otherState.m_61143_(PART) == Part.SINGLE || otherState.m_61143_(PART) == Part.TAIL)) {
            blockState = (BlockState)blockState.m_61124_(PART, (Comparable)((Object)Part.TAIL));
        }
        if (blockState.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) {
            return (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(PART) != Part.MIDDLE) {
            return NOT_MIDDLE;
        }
        return BASE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public static enum Part implements StringRepresentable
    {
        SINGLE("single"),
        STEM("stem"),
        MIDDLE("middle"),
        TAIL("tail");

        private final String name;

        private Part(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

