/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.BananaBlossomPlantBlock;
import com.stevekung.fishofthieves.block.BananaClusterPlantBlock;
import com.stevekung.fishofthieves.block.BananaHangingType;
import com.stevekung.fishofthieves.block.BananaLeavesBlock;
import com.stevekung.fishofthieves.block.BananaStemBlock;
import com.stevekung.fishofthieves.block.UnderripeBananaClusterPlantBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.util.TriConsumer;

public class BananaClusterGrowableStemBlock
extends BananaStemBlock
implements BonemealableBlock {
    public BananaClusterGrowableStemBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_46471_() && level.m_45527_(pos) && random.m_188503_(8) == 0) {
            this.growRandomBananaCluster(level, random, pos);
        }
    }

    @Override
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)FOTBlocks.BANANA_STEM);
    }

    @Override
    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return Direction.Plane.HORIZONTAL.m_122557_().anyMatch(direction -> this.canGrowBananaBunch((BlockGetter)level, pos, (Direction)direction));
    }

    @Override
    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.m_188503_(level.m_46471_() ? 3 : 4) == 0;
    }

    @Override
    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growRandomBananaCluster(level, random, pos);
    }

    private boolean canGrowBananaBunch(BlockGetter level, BlockPos pos, Direction direction) {
        BlockState leavesState = level.m_8055_(pos.m_121945_(direction));
        if (leavesState.m_60713_(FOTBlocks.BANANA_LEAVES)) {
            return leavesState.m_61143_(BananaLeavesBlock.TYPE) == BananaLeavesBlock.Type.UPPER && level.m_8055_(pos.m_7495_().m_121945_(direction)).m_60795_();
        }
        return false;
    }

    private void growRandomBananaCluster(ServerLevel level, RandomSource random, BlockPos pos) {
        Direction.Plane.HORIZONTAL.m_235694_(random).stream().filter(direction -> this.canGrowBananaBunch((BlockGetter)level, pos, (Direction)direction)).findFirst().ifPresent(direction -> BananaClusterGrowableStemBlock.growBananaBlossomOrCluster(direction, (LevelSimulatedReader)level, (TriConsumer<BlockPos, BlockState, Integer>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((ServerLevel)level).m_7731_(arg_0, arg_1, arg_2)), blockPos -> level.m_6425_(blockPos).m_76152_() == Fluids.f_76193_, random, pos.m_7495_().m_121945_(direction)));
    }

    public static void growBananaBlossomOrCluster(Direction direction, LevelSimulatedReader level, TriConsumer<BlockPos, BlockState, Integer> setBlock, Function<BlockPos, Boolean> isWater, RandomSource random, BlockPos pos) {
        int maxY = BananaClusterGrowableStemBlock.findMaxYBelow(level, pos);
        boolean isSmallCluster = false;
        if (maxY == 1) {
            setBlock.accept((Object)pos, (Object)BananaClusterGrowableStemBlock.createBlossomState(direction, isWater.apply(pos), BananaHangingType.STEM), (Object)3);
        } else {
            int yBottom = 0;
            int randHeight = 1 + random.m_188503_(maxY);
            for (int height = 0; height < randHeight; ++height) {
                BlockPos blockPos = pos.m_6625_(height);
                Predicate<BlockState> stateAbove = state -> level.m_7433_(blockPos.m_7494_(), blockState -> blockState.m_60713_(state.m_60734_()));
                BlockState banana = BananaClusterGrowableStemBlock.selectBananaState(random);
                banana = BananaClusterGrowableStemBlock.updateBananaHangingState(banana, stateAbove, height);
                isSmallCluster |= banana.m_61138_(UnderripeBananaClusterPlantBlock.HANGING);
                setBlock.accept((Object)blockPos, (Object)((BlockState)((BlockState)banana.m_61124_((Property)BananaClusterPlantBlock.f_54117_, (Comparable)direction.m_122424_())).m_61124_((Property)BananaClusterPlantBlock.WATERLOGGED, (Comparable)isWater.apply(blockPos))), (Object)3);
                yBottom = Math.max(yBottom, height);
            }
            setBlock.accept((Object)pos.m_6625_(yBottom), (Object)BananaClusterGrowableStemBlock.createBlossomState(direction, isWater.apply(pos.m_6625_(yBottom)), BananaClusterGrowableStemBlock.determineHangingType(yBottom, isSmallCluster)), (Object)3);
        }
    }

    private static BlockState createBlossomState(Direction direction, boolean isWaterlogged, BananaHangingType hangingType) {
        return (BlockState)((BlockState)((BlockState)FOTBlocks.BANANA_BLOSSOM_PLANT.m_49966_().m_61124_((Property)BananaBlossomPlantBlock.FACING, (Comparable)direction.m_122424_())).m_61124_(BananaBlossomPlantBlock.HANGING, (Comparable)((Object)hangingType))).m_61124_((Property)BananaBlossomPlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    private static BlockState selectBananaState(RandomSource random) {
        return random.m_188501_() < 0.2f ? FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.m_49966_() : (random.m_188501_() < 0.4f ? FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT.m_49966_() : FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT.m_49966_());
    }

    private static BlockState updateBananaHangingState(BlockState banana, Predicate<BlockState> stateAbove, int i) {
        if (banana.m_61138_(BananaClusterPlantBlock.HANGING)) {
            banana = (BlockState)banana.m_61124_(BananaClusterPlantBlock.HANGING, (Comparable)((Object)(i == 0 ? BananaClusterPlantBlock.HangingType.STEM : BananaClusterPlantBlock.HangingType.NONE)));
            if (stateAbove.test(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT.m_49966_())) {
                banana = (BlockState)banana.m_61124_(BananaClusterPlantBlock.HANGING, (Comparable)((Object)BananaClusterPlantBlock.HangingType.SMALL_CLUSTER));
            }
        } else if (banana.m_61138_(UnderripeBananaClusterPlantBlock.HANGING)) {
            boolean isLargeCluster;
            boolean bl = isLargeCluster = stateAbove.test(FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.m_49966_()) || stateAbove.test(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT.m_49966_());
            banana = (BlockState)banana.m_61124_(UnderripeBananaClusterPlantBlock.HANGING, (Comparable)((Object)(i == 0 ? BananaHangingType.STEM : (isLargeCluster ? BananaHangingType.CLUSTER : BananaHangingType.SMALL_CLUSTER))));
        }
        return banana;
    }

    private static BananaHangingType determineHangingType(int yBottom, boolean isSmallCluster) {
        return yBottom == 0 ? BananaHangingType.STEM : (isSmallCluster ? BananaHangingType.SMALL_CLUSTER : BananaHangingType.CLUSTER);
    }

    private static int findMaxYBelow(LevelSimulatedReader level, BlockPos pos) {
        int maxY;
        for (maxY = 0; level.m_7433_(pos.m_6625_(maxY), BlockBehaviour.BlockStateBase::m_247087_) && maxY < 6; ++maxY) {
        }
        return maxY;
    }
}

