/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.world.structures;

import com.hexagram2021.oceanworld.common.register.OWStructureTypes;
import com.hexagram2021.oceanworld.common.world.OceanJigsawPlacement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class UnderwaterJigsawStructureFeature
extends Structure {
    public static final int MAX_TOTAL_STRUCTURE_RANGE = 128;
    public static final Codec<UnderwaterJigsawStructureFeature> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UnderwaterJigsawStructureFeature.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(feature -> feature.startPool), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(feature -> feature.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(feature -> feature.startHeight), (App)Codec.intRange((int)-60, (int)60).fieldOf("max_generate_height").forGetter(feature -> feature.maxGenerateHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(feature -> feature.useExpansionHack), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(feature -> feature.maxDistanceFromCenter)).apply((Applicative)instance, UnderwaterJigsawStructureFeature::new)).flatXmap(UnderwaterJigsawStructureFeature.verifyRange(), UnderwaterJigsawStructureFeature.verifyRange()).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final int maxGenerateHeight;
    private final boolean useExpansionHack;
    private final int maxDistanceFromCenter;

    private static Function<UnderwaterJigsawStructureFeature, DataResult<UnderwaterJigsawStructureFeature>> verifyRange() {
        return feature -> {
            int adaptation = switch (feature.m_226620_()) {
                default -> throw new IncompatibleClassChangeError();
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
            };
            return feature.maxDistanceFromCenter + adaptation > 128 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed %d".formatted(128)) : DataResult.success((Object)feature);
        };
    }

    public UnderwaterJigsawStructureFeature(Structure.StructureSettings settings, Holder<StructureTemplatePool> startPool, int maxDepth, HeightProvider startHeight, int maxGenerateHeight, boolean useExpansionHack, int maxDistanceFromCenter) {
        super(settings);
        this.startPool = startPool;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.maxGenerateHeight = maxGenerateHeight;
        this.useExpansionHack = useExpansionHack;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        int x = chunkpos.m_45604_();
        int z = chunkpos.m_45605_();
        if (context.f_226622_().m_223235_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_()) > this.maxGenerateHeight) {
            return Optional.empty();
        }
        BlockPos blockpos = new BlockPos(x, 1, z);
        return OceanJigsawPlacement.addPieces(context, this.startPool, null, this.maxDepth, blockpos, this.useExpansionHack, this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)OWStructureTypes.UNDERWATER_JIGSAW.get();
    }
}

