/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.world.spawners;

import com.hexagram2021.oceanworld.common.OWLogger;
import com.hexagram2021.oceanworld.common.config.OWCommonConfig;
import com.hexagram2021.oceanworld.common.register.OWEntities;
import com.hexagram2021.oceanworld.common.world.spawners.OceanWorldSpawner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class OceanPatrolSpawner
implements OceanWorldSpawner {
    private final boolean again;
    private int nextTick = (Integer)OWCommonConfig.OCEAN_PATROL_SPAWN_INTERVAL.get() * 20;

    public OceanPatrolSpawner() {
        this(false);
    }

    public OceanPatrolSpawner(boolean tryAgain) {
        this.again = tryAgain;
    }

    @Override
    public void tick(ServerLevel serverLevel) {
        if (!serverLevel.m_7726_().f_8335_ || !serverLevel.m_46469_().m_46207_(GameRules.f_46124_)) {
            return;
        }
        RandomSource random = serverLevel.f_46441_;
        --this.nextTick;
        if (this.nextTick <= 0) {
            this.nextTick += (Integer)OWCommonConfig.OCEAN_PATROL_SPAWN_INTERVAL.get() * 20 + random.m_188503_((Integer)OWCommonConfig.OCEAN_PATROL_SPAWN_INTERVAL.get() * 20 / 10);
            if (serverLevel.m_46468_() / 24000L >= 10L && serverLevel.m_46461_()) {
                if (!(random.m_188503_(100) >= (Integer)OWCommonConfig.OCEAN_PATROL_SPAWN_CHANCE.get() || this.again && random.m_188503_(120) < (Integer)OWCommonConfig.OCEAN_PATROL_SPAWN_CHANCE.get())) {
                    return;
                }
                int playerCount = serverLevel.m_6907_().size();
                if (playerCount < 1) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)serverLevel.m_6907_().get(random.m_188503_(playerCount));
                if (player.m_5833_() || serverLevel.m_8736_(player.m_20183_(), 2)) {
                    return;
                }
                int x = (32 + random.m_188503_(16)) * (random.m_188499_() ? -1 : 1);
                int z = (32 + random.m_188503_(16)) * (random.m_188499_() ? -1 : 1);
                BlockPos.MutableBlockPos spawnPos = player.m_20183_().m_122032_().m_122184_(x, 0, z).m_142448_(serverLevel.m_5736_() + 1);
                if (!serverLevel.m_151572_(spawnPos.m_123341_() - 10, spawnPos.m_123343_() - 10, spawnPos.m_123341_() + 10, spawnPos.m_123343_() + 10)) {
                    return;
                }
                Holder holder = serverLevel.m_204166_((BlockPos)spawnPos);
                if (!(holder.m_203656_(BiomeTags.f_207603_) && serverLevel.m_8055_(spawnPos.m_7495_()).m_60795_() && serverLevel.m_8055_(spawnPos.m_6625_(2)).m_60713_(Blocks.f_49990_))) {
                    return;
                }
                int tries = (int)Math.ceil(serverLevel.m_6436_((BlockPos)spawnPos).m_19056_()) + 1;
                Boat.Type boatType = switch (random.m_188503_(7)) {
                    case 0 -> Boat.Type.BIRCH;
                    case 1, 2, 3, 4 -> Boat.Type.DARK_OAK;
                    default -> Boat.Type.OAK;
                };
                for (int i = 0; i < tries; ++i) {
                    if (i == 0) {
                        if (!this.spawnPatrolMember(serverLevel, (BlockPos)spawnPos, boatType, player, true)) {
                            return;
                        }
                    } else {
                        this.spawnPatrolMember(serverLevel, (BlockPos)spawnPos, boatType, player, false);
                    }
                    spawnPos.m_142451_(spawnPos.m_123341_() + random.m_188503_(8) - random.m_188503_(8));
                    spawnPos.m_142443_(spawnPos.m_123343_() + random.m_188503_(8) - random.m_188503_(8));
                }
                OWLogger.LOGGER.debug("Spawn ocean patrol at %s (%d, %d, %d).".formatted(serverLevel.m_46472_(), spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_()));
            }
        }
    }

    @Override
    public void reset() {
        this.nextTick = (Integer)OWCommonConfig.OCEAN_PATROL_SPAWN_INTERVAL.get();
    }

    private boolean spawnPatrolMember(ServerLevel serverLevel, BlockPos blockPos, Boat.Type boatType, ServerPlayer player, boolean leader) {
        if (!OceanPatrolSpawner.checkOceanPatrollingMonsterSpawnRules((LevelAccessor)serverLevel, blockPos)) {
            return false;
        }
        Boat boat = (Boat)EntityType.f_20552_.m_20615_((Level)serverLevel);
        if (boat == null) {
            return false;
        }
        boat.m_28464_(boatType);
        PatrollingMonster oceanologer = (PatrollingMonster)OWEntities.OCEANOLOGER.m_20615_((Level)serverLevel);
        if (oceanologer != null) {
            if (leader) {
                oceanologer.m_33075_(true);
                oceanologer.m_33070_(player.m_20183_());
            }
            oceanologer.m_6034_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            oceanologer.m_6710_((LivingEntity)player);
            oceanologer.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(blockPos), MobSpawnType.PATROL, null, null);
            boat.m_6034_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
            oceanologer.m_20329_((Entity)boat);
            serverLevel.m_7967_((Entity)oceanologer);
            serverLevel.m_7967_((Entity)boat);
            return true;
        }
        boat.m_146870_();
        return false;
    }

    private static boolean checkOceanPatrollingMonsterSpawnRules(LevelAccessor level, BlockPos blockPos) {
        return level.m_45517_(LightLayer.BLOCK, blockPos) <= 8 && level.m_46791_() != Difficulty.PEACEFUL;
    }
}

